/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.common.items.FakeBuilderWorld;
import com.direwolf20.buildinggadgets.common.items.ModItems;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.ExchangingModes;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.NBTTool;
import com.direwolf20.buildinggadgets.common.tools.ToolRenders;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GadgetExchanger
extends GadgetGeneric {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public GadgetExchanger() {
        super("exchangertool");
        this.func_77656_e(SyncedConfig.durabilityExchanger);
    }

    public int getMaxDamage(ItemStack stack) {
        return SyncedConfig.poweredByFE ? 0 : SyncedConfig.durabilityExchanger;
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return SyncedConfig.energyCostExchanger;
    }

    @Override
    public int getDamageCost(ItemStack tool) {
        return SyncedConfig.damageCostExchanger;
    }

    public int func_77619_b() {
        return 3;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        if (EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185306_r)) {
            return true;
        }
        return super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185306_r) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private static void setToolMode(ItemStack tool, ExchangingModes mode) {
        NBTTagCompound tagCompound = NBTTool.getOrNewTag(tool);
        tagCompound.func_74778_a("mode", mode.getRegistryName());
    }

    public static ExchangingModes getToolMode(ItemStack tool) {
        NBTTagCompound tagCompound = NBTTool.getOrNewTag(tool);
        return ExchangingModes.byName(tagCompound.func_74779_i("mode"));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, world, list, b);
        list.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltip.gadget.block", (Object[])new Object[0]) + ": " + GadgetUtils.getToolBlock(stack).func_177230_c().func_149732_F());
        ExchangingModes mode = GadgetExchanger.getToolMode(stack);
        list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.gadget.mode", (Object[])new Object[0]) + ": " + (mode == ExchangingModes.Surface && GadgetExchanger.getConnectedArea(stack) ? I18n.func_135052_a((String)"tooltip.gadget.connected", (Object[])new Object[0]) + " " : "") + (Object)((Object)mode));
        list.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"tooltip.gadget.range", (Object[])new Object[0]) + ": " + GadgetUtils.getToolRange(stack));
        list.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.gadget.fuzzy", (Object[])new Object[0]) + ": " + GadgetExchanger.getFuzzy(stack));
        GadgetExchanger.addInformationRayTraceFluid(list, stack);
        this.addEnergyInformation(list, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(itemstack, player);
            } else {
                this.exchange(player, itemstack);
            }
        } else if (!player.func_70093_af()) {
            ToolRenders.updateInventoryCache();
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ExchangingModes mode = ExchangingModes.values()[modeInt];
        GadgetExchanger.setToolMode(heldItem, mode);
    }

    public void rangeChange(EntityPlayer player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetExchanger.getToolMode(heldItem) == ExchangingModes.Grid || range % 2 == 0 ? 1 : 2;
        range = player.func_70093_af() ? (range <= 1 ? SyncedConfig.maxRange : range - changeAmount) : (range >= SyncedConfig.maxRange ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_AQUA + new TextComponentTranslation("message.gadget.toolrange", new Object[0]).func_150261_e() + ": " + range), true);
    }

    private boolean exchange(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        List<BlockPos> coords = GadgetUtils.getAnchor(stack);
        if (coords.size() == 0) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
            if (lookingAt == null) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_178782_a();
            EnumFacing sideHit = lookingAt.field_178784_b;
            coords = ExchangingModes.collectPlacementPos(world, player, startBlock, sideHit, stack, startBlock);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
        }
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>(coords);
        ItemStack heldItem = GadgetExchanger.getGadget(player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        IBlockState blockState = GadgetUtils.getToolBlock(heldItem);
        if (blockState != Blocks.field_150350_a.func_176223_P()) {
            IBlockState state = Blocks.field_150350_a.func_176223_P();
            fakeWorld.setWorldAndState(player.field_70170_p, blockState, coordinates);
            for (BlockPos coordinate : coords) {
                if (fakeWorld.func_175624_G() != WorldType.field_180272_g) {
                    try {
                        state = blockState.func_185899_b((IBlockAccess)fakeWorld, coordinate);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.exchangeBlock(world, player, coordinate, state);
            }
            GadgetUtils.clearCachedRemoteInventory();
        }
        return true;
    }

    private boolean exchangeBlock(World world, EntityPlayer player, BlockPos pos, IBlockState setBlock) {
        ItemStack tool;
        IBlockState currentBlock = world.func_180495_p(pos);
        boolean useConstructionPaste = false;
        ItemStack itemStack = setBlock.func_177230_c().canSilkHarvest(world, pos, setBlock, player) ? InventoryManipulation.getSilkTouchDrop(setBlock) : setBlock.func_177230_c().getPickBlock(setBlock, null, world, pos, player);
        if (itemStack.func_77973_b().equals(Items.field_190931_a)) {
            itemStack = setBlock.func_177230_c().getPickBlock(setBlock, null, world, pos, player);
        }
        if ((tool = GadgetExchanger.getGadget(player)).func_190926_b()) {
            return false;
        }
        NonNullList drops = NonNullList.func_191196_a();
        setBlock.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, setBlock, 0);
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (InventoryManipulation.countItem(itemStack, player, world) < neededItems) {
            ItemStack constructionPaste = new ItemStack((Item)ModItems.constructionPaste);
            if (InventoryManipulation.countPaste(player) < neededItems) {
                return false;
            }
            itemStack = constructionPaste.func_77946_l();
            useConstructionPaste = true;
        }
        if (!player.func_175142_cm()) {
            return false;
        }
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        if (!GadgetGeneric.EmitEvent.breakBlock(world, pos, currentBlock, player)) {
            return false;
        }
        if (!this.canUse(tool, player)) {
            return false;
        }
        if (!GadgetExchanger.canPlaceBlockAt(world, pos, setBlock, currentBlock)) {
            return false;
        }
        this.applyDamage(tool, player);
        currentBlock.func_177230_c().func_180657_a(world, player, pos, currentBlock, world.func_175625_s(pos), tool);
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        if (!GadgetGeneric.EmitEvent.placeBlock(player, blockSnapshot, player.func_174811_aO(), player.func_184600_cs())) {
            return false;
        }
        boolean useItemSuccess = useConstructionPaste ? InventoryManipulation.usePaste(player, 1) : InventoryManipulation.useItem(itemStack, player, neededItems, world);
        if (useItemSuccess) {
            world.func_72838_d((Entity)new BlockBuildEntity(world, pos, (EntityLivingBase)player, setBlock, 3, GadgetUtils.getToolActualBlock(tool), useConstructionPaste));
            return true;
        }
        return false;
    }

    private static boolean canPlaceBlockAt(World world, BlockPos pos, IBlockState setBlock, IBlockState originalBlock) {
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        boolean canPlace = setBlock.func_177230_c().func_176196_c(world, pos);
        world.func_175656_a(pos, originalBlock);
        return canPlace;
    }

    public static ItemStack getGadget(EntityPlayer player) {
        ItemStack stack = GadgetGeneric.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetExchanger)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

