/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.building.IBuildingMode;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingGridMode;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingHorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingSurfaceMode;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingVerticalColumnMode;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.NBTTool;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public enum ExchangingModes {
    Surface("surface.png", new ExchangingSurfaceMode(ExchangingModes::combineTester)),
    VerticalColumn("vertical_column.png", new ExchangingVerticalColumnMode(ExchangingModes::combineTester)),
    HorizontalColumn("horizontal_column.png", new ExchangingHorizontalColumnMode(ExchangingModes::combineTester)),
    Grid("grid.png", new ExchangingGridMode(ExchangingModes::combineTester));

    private static final ExchangingModes[] VALUES;
    private final ResourceLocation icon;
    private final IBuildingMode modeImpl;
    private static final ImmutableList<ResourceLocation> ICONS;

    private ExchangingModes(String iconFile, IBuildingMode modeImpl) {
        this.icon = new ResourceLocation("buildinggadgets", "textures/gui/mode/" + iconFile);
        this.modeImpl = modeImpl;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public IBuildingMode getModeImplementation() {
        return this.modeImpl;
    }

    public String getRegistryName() {
        return this.getModeImplementation().getRegistryName().toString() + "/ExchangingGadget";
    }

    public String toString() {
        return this.getModeImplementation().getLocalized();
    }

    public ExchangingModes next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static ExchangingModes byName(String name) {
        return Arrays.stream(ExchangingModes.values()).filter(mode -> mode.getRegistryName().equals(name)).findFirst().orElse(Surface);
    }

    public static ImmutableList<ResourceLocation> getIcons() {
        return ICONS;
    }

    public static List<BlockPos> collectPlacementPos(World world, EntityPlayer player, BlockPos hit, EnumFacing sideHit, ItemStack tool, BlockPos initial) {
        IBuildingMode mode = ExchangingModes.byName(NBTTool.getOrNewTag(tool).func_74779_i("mode")).getModeImplementation();
        return mode.createExecutionContext(player, hit, sideHit, tool).collectFilteredSequence(world, tool, player, initial);
    }

    public static BiPredicate<BlockPos, IBlockState> combineTester(World world, ItemStack tool, EntityPlayer player, BlockPos initial) {
        IBlockState initialBlockState = world.func_180495_p(initial);
        IBlockState target = GadgetUtils.getToolBlock(tool);
        return (pos, state) -> {
            IBlockState worldBlockState = world.func_180495_p(pos);
            if (worldBlockState == target) {
                return false;
            }
            if (!GadgetGeneric.getFuzzy(tool) && worldBlockState != initialBlockState) {
                return false;
            }
            if (worldBlockState == ModBlocks.effectBlock.func_176223_P()) {
                return false;
            }
            if (worldBlockState.func_177230_c().isAir(worldBlockState, (IBlockAccess)world, pos)) {
                return false;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof ConstructionBlockTileEntity && ((ConstructionBlockTileEntity)tile).getBlockState() == state) {
                return false;
            }
            if (tile != null) {
                return false;
            }
            if (worldBlockState.func_185887_b(world, pos) < 0.0f) {
                return false;
            }
            return !worldBlockState.func_185904_a().func_76224_d();
        };
    }

    static {
        VALUES = ExchangingModes.values();
        ICONS = (ImmutableList)Arrays.stream(ExchangingModes.values()).map(ExchangingModes::getIcon).collect(ImmutableList.toImmutableList());
    }
}

