/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.dataloader;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.darkhax.bookshelf.dataloader.sources.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class DataLoader {
    private final List<IDataProvider> dataProviders = new ArrayList<IDataProvider>();
    private final Map<String, BiConsumer<ResourceLocation, BufferedReader>> processors = new HashMap<String, BiConsumer<ResourceLocation, BufferedReader>>();
    private final Logger logger;

    public DataLoader(Logger log) {
        this.logger = log;
    }

    public DataLoader addDataProvider(IDataProvider provider) {
        this.dataProviders.add(provider);
        return this;
    }

    public DataLoader addProcessor(String dataType, BiConsumer<ResourceLocation, BufferedReader> fileProcessor) {
        this.processors.put(dataType, fileProcessor);
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Map<String, BiConsumer<ResourceLocation, BufferedReader>> getProcessors() {
        return this.processors;
    }

    public void loadData() {
        for (IDataProvider source : this.dataProviders) {
            source.provideDataToProcessors(this);
        }
    }
}

