/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.dataloader.sources;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.dataloader.DataLoader;
import net.darkhax.bookshelf.dataloader.sources.DataProviderPredicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;

public class DataProviderMods
extends DataProviderPredicate {
    private final String ownerId;

    public DataProviderMods(String ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public void provideDataToProcessors(DataLoader loader) {
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            try {
                PathResolver resolver = new PathResolver(mod);
                Throwable throwable = null;
                try {
                    for (Map.Entry<String, BiConsumer<ResourceLocation, BufferedReader>> entry : loader.getProcessors().entrySet()) {
                        String processorType = entry.getKey();
                        Path root = resolver.getPath("data/" + mod.getModId() + "/" + this.ownerId + "/" + processorType);
                        if (root == null || !Files.exists(root, new LinkOption[0])) continue;
                        Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);
                        Throwable throwable2 = null;
                        try {
                            stream.forEach(path -> this.processFromPath(loader, mod, root, (Path)path, processorType, (BiConsumer)entry.getValue()));
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (resolver == null) continue;
                    if (throwable != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    resolver.close();
                }
            }
            catch (IOException e) {
                loader.getLogger().error("Error while loading data from {}.", (Object)mod.getModId());
                loader.getLogger().catching((Throwable)e);
            }
        }
    }

    protected void processFromPath(DataLoader loader, ModContainer mod, Path root, Path file, String processorType, BiConsumer<ResourceLocation, BufferedReader> processor) {
        String relative = root.relativize(file).toString();
        if (this.getPathValidator().test(file)) {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
                ResourceLocation entryId = new ResourceLocation(mod.getModId(), name);
                processor.accept(entryId, reader);
            }
            catch (Exception e) {
                loader.getLogger().error("Failed to read file {}. The file was not valid.", (Object)file);
                loader.getLogger().catching((Throwable)e);
            }
        }
    }

    class PathResolver
    implements Closeable {
        private final File source;
        @Nullable
        private FileSystem fs;

        public PathResolver(ModContainer mod) throws IOException {
            this.source = mod.getSource();
            if (this.source.isFile()) {
                this.fs = FileSystems.newFileSystem(this.source.toPath(), null);
            }
        }

        public Path getPath(String base) {
            return this.fs != null ? this.fs.getPath("/", base) : this.source.toPath().resolve(base);
        }

        @Override
        public void close() throws IOException {
            if (this.fs != null) {
                this.fs.close();
            }
        }
    }
}

