/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import cubex2.cxlibrary.util.ClientUtil;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.util.Rectangle;

public class GuiTexture {
    private final ResourceLocation location;
    private final int texWidth;
    private final int texHeight;
    private Map<String, Rectangle> parts = Maps.newHashMap();

    public GuiTexture(ResourceLocation location, int width, int height, boolean hasPartJson) {
        this.location = location;
        this.texWidth = width;
        this.texHeight = height;
        if (hasPartJson) {
            this.loadTextureParts();
        }
    }

    private void loadTextureParts() {
        String json = ClientUtil.readResource(new ResourceLocation(this.location.toString().replace(".png", ".parts.json")));
        if (json == null) {
            return;
        }
        Type type = new TypeToken<Map<String, Rectangle>>(){}.getType();
        Map map = (Map)ClientUtil.gson.fromJson(json, type);
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            this.addPart((String)entry.getKey(), (Rectangle)entry.getValue());
        }
    }

    public Rectangle getPart(String key) {
        return this.parts.get(key);
    }

    public void addPart(String key, int x, int y, int width, int height) {
        this.parts.put(key, new Rectangle(x, y, width, height));
    }

    public void addPart(String key, Rectangle rect) {
        this.parts.put(key, rect);
    }

    public void draw(int x, int y, int u, int v, int width, int height) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.location);
        Gui.func_146110_a((int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (float)this.texWidth, (float)this.texHeight);
    }

    public void draw(int x, int y, int u, int v, int maxWidth, int maxHeight, float width, float height) {
        int w = (int)((float)maxWidth * width);
        int h = (int)((float)maxHeight * height);
        if (width < 0.0f) {
            w = maxWidth + w;
            u += maxWidth - h;
            x += maxWidth - w;
        }
        if (height < 0.0f) {
            h = maxHeight + h;
            v += maxHeight - h;
            y += maxHeight - h;
        }
        this.draw(x, y, u, v, w, h);
    }

    public void drawPart(String key, int x, int y, float width, float height) {
        Rectangle rect = this.parts.get(key);
        this.draw(x, y, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), width, height);
    }

    public void drawPart(String key, int x, int y) {
        Rectangle rect = this.parts.get(key);
        this.draw(x, y, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void drawPart(String key, int x, int y, int width, int height) {
        Rectangle rect = this.parts.get(key);
        this.draw(x, y, rect.getX(), rect.getY(), width, height);
    }

    public void drawPartSliced(String key, Rectangle rect) {
        this.drawPartSliced(key, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void drawPartSliced(String key, int x, int y, int width, int height) {
        Rectangle rect = this.parts.get(key);
        this.drawSliced(x, y, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), width, height);
    }

    public void drawSliced(int _x, int _y, int u, int v, int uWidth, int uHeight, int width, int height) {
        int heightChange = height % 2 != 0 ? 1 : 0;
        int widthChange = width % 2 != 0 ? 1 : 0;
        int x = _x;
        int y = _y;
        int cH = width / 2;
        int cV = height / 2;
        this.draw(x, y, u, v, cH + widthChange, cV + heightChange);
        this.draw(x + cH + widthChange, y, u + uWidth - cH, v, cH, cV + heightChange);
        this.draw(x, y + cV + heightChange, u, v + uHeight - cV, cH + widthChange, cV);
        this.draw(x + cH + widthChange, y + cV + heightChange, u + uWidth - cH, v + uHeight - cV, cH, cV);
    }
}

