/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.data;

import cubex2.cxlibrary.gui.control.SlotControl;
import cubex2.cxlibrary.util.Cloneable;

public class SlotData
implements Cloneable<SlotData> {
    private int from;
    private int to;
    private int rows = 1;
    private int x;
    private int y;

    public boolean apply(SlotControl.Builder builder) {
        int index = builder.slot.getSlotIndex();
        int minIndex = Math.min(this.from, this.to);
        int maxIndex = Math.max(this.from, this.to);
        if (minIndex > index || maxIndex < index) {
            return false;
        }
        int numSlots = maxIndex - minIndex + 1;
        int cols = numSlots / this.rows;
        if (cols * this.rows != numSlots) {
            return false;
        }
        index -= minIndex;
        if (this.to < this.from) {
            index = numSlots - 1 - index;
        }
        int gridX = index % cols;
        int gridY = index / cols;
        if (this.x >= 0) {
            builder.left(gridX * 18 + this.x);
        } else {
            builder.right(-gridX * 18 - this.x - 16);
        }
        if (this.y >= 0) {
            builder.top(gridY * 18 + this.y);
        } else {
            builder.bottom(-gridY * 18 - this.y - 16);
        }
        return true;
    }

    @Override
    public SlotData clone() {
        SlotData data = new SlotData();
        data.from = this.from;
        data.to = this.to;
        data.rows = this.rows;
        data.x = this.x;
        data.y = this.y;
        return data;
    }
}

