/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.blocks;

import exnihilocreatio.ExNihiloCreatio;
import exnihilocreatio.barrel.IBarrelMode;
import exnihilocreatio.barrel.modes.block.BarrelModeBlock;
import exnihilocreatio.barrel.modes.compost.BarrelModeCompost;
import exnihilocreatio.barrel.modes.fluid.BarrelModeFluid;
import exnihilocreatio.barrel.modes.transform.BarrelModeFluidTransform;
import exnihilocreatio.blocks.BlockBase;
import exnihilocreatio.compatibility.ITOPInfoProvider;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.Util;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;

public class BlockBarrel
extends BlockBase
implements ITileEntityProvider,
ITOPInfoProvider {
    private final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    private final int tier;

    public BlockBarrel(int tier, Material material) {
        super(material, "block_barrel" + tier);
        this.tier = tier;
        this.func_149711_c(2.0f);
        this.func_149647_a(ExNihiloCreatio.tabExNihilo);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        ItemStack stack;
        IItemHandler barrelCap;
        TileBarrel barrel;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileBarrel && (barrel = (TileBarrel)te).getMode() != null && barrel.getMode().getName().equals("block") && (barrelCap = (IItemHandler)barrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && !(stack = barrelCap.getStackInSlot(0)).func_190926_b()) {
            Util.dropItemInWorld(te, null, stack, 0.0);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBarrel && ModConfig.misc.enableBarrelLighting) {
            TileBarrel tile = (TileBarrel)te;
            if (tile.getMode() instanceof BarrelModeBlock) {
                BarrelModeBlock mode = (BarrelModeBlock)tile.getMode();
                if (mode.getBlock() != null) {
                    return Block.func_149634_a((Item)mode.getBlock().getItem()).func_176203_a(mode.getBlock().getMeta()).func_185906_d();
                }
            } else if (tile.getMode() instanceof BarrelModeFluid) {
                BarrelModeFluid mode = (BarrelModeFluid)tile.getMode();
                if (mode.getFluidHandler(tile).getFluidAmount() > 0) {
                    return Util.getLightValue(mode.getFluidHandler(tile).getFluid());
                }
            } else if (ModConfig.misc.enableBarrelTransformLighting) {
                if (tile.getMode() instanceof BarrelModeCompost) {
                    BarrelModeCompost mode = (BarrelModeCompost)tile.getMode();
                    if (mode.getCompostState() != null) {
                        int value = mode.getCompostState().func_185906_d() / 2;
                        return Math.round(Util.weightedAverage((float)value / 2.0f, value, mode.getProgress()));
                    }
                } else if (tile.getMode() instanceof BarrelModeFluidTransform) {
                    BarrelModeFluidTransform mode = (BarrelModeFluidTransform)tile.getMode();
                    int inputValue = Util.getLightValue(mode.getInputStack());
                    int outputValue = Util.getLightValue(mode.getOutputStack());
                    return Math.round(Util.weightedAverage(outputValue, inputValue, mode.getProgress()));
                }
            }
        }
        return super.getLightValue(state, world, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return worldIn.field_72995_K || worldIn.func_175625_s(pos) == null || ((TileBarrel)worldIn.func_175625_s(pos)).onBlockActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileBarrel(this);
    }

    @Nonnull
    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        IBarrelMode barrelMode;
        TileBarrel barrel = (TileBarrel)world.func_175625_s(data.getPos());
        if (barrel == null) {
            return;
        }
        if (mode == ProbeMode.EXTENDED) {
            probeInfo.text(TextFormatting.GREEN + "Mode: " + StringUtils.capitalize((String)barrel.getMode().getName()));
        }
        if ((barrelMode = barrel.getMode()) != null) {
            List<String> tooltips = barrelMode.getWailaTooltip(barrel, new ArrayList<String>());
            for (String tooltip : tooltips) {
                probeInfo.text(tooltip);
            }
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileBarrel) {
            ((TileBarrel)te).entityOnTop(worldIn, entityIn);
        }
    }

    public int getTier() {
        return this.tier;
    }
}

