/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.client.renderers;

import exnihilocreatio.blocks.BlockCrucibleBase;
import exnihilocreatio.client.models.ModelVertex;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.texturing.SpriteColor;
import exnihilocreatio.tiles.TileCrucibleBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.animation.FastTESR;

public class RenderCrucible
extends FastTESR<TileCrucibleBase> {
    private static final ModelVertex[] model_thick = new ModelVertex[4];
    private static final ModelVertex[] model_thin = new ModelVertex[4];

    public void renderTileEntityFast(@Nullable TileCrucibleBase te, double x, double y, double z, float partialTicks, int destroyStage, float partial, @Nullable BufferBuilder buffer) {
        if (te == null || buffer == null) {
            return;
        }
        BlockPos pos = te.func_174877_v();
        Block block = this.func_178459_a().func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockCrucibleBase)) {
            return;
        }
        SpriteColor[] sprites = te.getSpriteAndColor();
        buffer.func_178969_c(x, y, z);
        this.addSpriteColor(te, sprites[0], buffer, te.getSolidProportion());
        this.addSpriteColor(te, sprites[1], buffer, te.getFluidProportion());
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }

    private void addSpriteColor(TileCrucibleBase te, SpriteColor sprite, BufferBuilder buffer, float fill) {
        ModelVertex[] model;
        if (sprite == null || fill <= 0.0f) {
            return;
        }
        BlockPos pos = te.func_174877_v();
        int mixedBrightness = te.func_145831_w().func_180495_p(pos).func_185889_a((IBlockAccess)te.func_145831_w(), te.func_174877_v());
        int skyLight = mixedBrightness >> 16 & 0xFFFF;
        int blockLight = mixedBrightness & 0xFFFF;
        TextureAtlasSprite icon = sprite.getSprite();
        Color color = sprite.getColor();
        if (icon == null) {
            return;
        }
        for (ModelVertex vert : model = ModConfig.client.thinCrucibleModel ? model_thin : model_thick) {
            for (VertexFormatElement e : buffer.func_178973_g().func_177343_g()) {
                switch (e.func_177375_c()) {
                    case COLOR: {
                        buffer.func_181666_a(color.r, color.g, color.b, color.a);
                        break;
                    }
                    case NORMAL: {
                        buffer.func_181663_c((float)vert.face.func_82601_c(), (float)vert.face.func_96559_d(), (float)vert.face.func_82599_e());
                        break;
                    }
                    case POSITION: {
                        double vertX = vert.x;
                        double vertY = vert.y * (double)fill + 0.25;
                        double vertZ = vert.z;
                        buffer.func_181662_b(vertX, vertY, vertZ);
                        break;
                    }
                    case UV: {
                        if (e.func_177369_e() == 1) {
                            buffer.func_187314_a(skyLight, blockLight);
                            break;
                        }
                        buffer.func_187315_a((double)icon.func_94214_a(vert.u), (double)icon.func_94207_b(16.0 - vert.v));
                        break;
                    }
                }
            }
            buffer.func_181675_d();
        }
    }

    static {
        RenderCrucible.model_thick[0] = new ModelVertex(EnumFacing.UP, 0.125, 0.6875, 0.125, 0.0, 0.0);
        RenderCrucible.model_thick[1] = new ModelVertex(EnumFacing.UP, 0.875, 0.6875, 0.125, 1.0, 0.0);
        RenderCrucible.model_thick[2] = new ModelVertex(EnumFacing.UP, 0.875, 0.6875, 0.875, 1.0, 1.0);
        RenderCrucible.model_thick[3] = new ModelVertex(EnumFacing.UP, 0.125, 0.6875, 0.875, 0.0, 1.0);
        RenderCrucible.model_thin[0] = new ModelVertex(EnumFacing.UP, 0.0625, 0.6875, 0.0625, 0.0, 0.0);
        RenderCrucible.model_thin[1] = new ModelVertex(EnumFacing.UP, 0.9375, 0.6875, 0.0625, 1.0, 0.0);
        RenderCrucible.model_thin[2] = new ModelVertex(EnumFacing.UP, 0.9375, 0.6875, 0.9375, 1.0, 1.0);
        RenderCrucible.model_thin[3] = new ModelVertex(EnumFacing.UP, 0.0625, 0.6875, 0.9375, 0.0, 1.0);
    }
}

