/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.crucible;

import exnihilocreatio.ModBlocks;
import exnihilocreatio.blocks.BlockCrucibleStone;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.RenderTickCounter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HeatSourcesRecipe
implements IRecipeWrapper {
    private final List<ItemStack> inputs;
    private final BlockInfo blockInfo;
    private final String heatAmountString;
    private static final Item torch = Item.func_150898_a((Block)Blocks.field_150478_aa);

    public HeatSourcesRecipe(BlockInfo blockInfo, int heatAmount) {
        this.blockInfo = blockInfo;
        ItemStack item = blockInfo.getItemStack();
        if (item.func_77973_b() == torch) {
            item = new ItemStack(torch, 1, 0);
        }
        if (item.func_190926_b()) {
            Fluid fluid = null;
            Block block = blockInfo.getBlock();
            if (block instanceof IFluidBlock) {
                fluid = ((IFluidBlock)block).getFluid();
            }
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                fluid = FluidRegistry.LAVA;
            }
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                fluid = FluidRegistry.WATER;
            }
            if (fluid != null) {
                item = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
            }
            if (block == Blocks.field_150480_ab) {
                item = new ItemStack(Items.field_151033_d, 1);
            }
        }
        this.inputs = new ArrayList<ItemStack>(Collections.singleton(item));
        this.heatAmountString = heatAmount + "x";
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b(this.heatAmountString, 24, 12, Color.gray.getRGB());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)216.5f);
        GlStateManager.func_179121_F();
        float angle = (float)RenderTickCounter.renderTicks * 45.0f / 128.0f;
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)70.0f, (float)30.0f, (float)20.0f);
        GlStateManager.func_179114_b((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_178969_c(-0.5, 0.0, -0.5);
        GlStateManager.func_179089_o();
        IBlockState crucible = ModBlocks.crucibleStone.func_176223_P().func_177226_a((IProperty)BlockCrucibleStone.FIRED, (Comparable)Boolean.valueOf(true));
        IBlockState state = this.blockInfo.getBlockState();
        BlockPos pos = new BlockPos(0, 0, 0);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GlStateManager.func_179118_c();
        this.renderBlock(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, crucible, new BlockPos(0, 1, 0), (IBlockAccess)minecraft.field_71441_e);
        this.renderBlock(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, state, pos, (IBlockAccess)minecraft.field_71441_e);
        GlStateManager.func_179141_d();
        this.renderBlock(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED, state, pos, (IBlockAccess)minecraft.field_71441_e);
        this.renderBlock(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT, state, pos, (IBlockAccess)minecraft.field_71441_e);
        GlStateManager.func_179103_j((int)7425);
        this.renderBlock(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT, state, pos, (IBlockAccess)minecraft.field_71441_e);
        tessellator.func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBlock(BlockRendererDispatcher blockrendererdispatcher, BufferBuilder buffer, BlockRenderLayer renderLayer, IBlockState blockState, BlockPos pos, IBlockAccess access) {
        if (!blockState.func_177230_c().canRenderInLayer(blockState, renderLayer)) {
            return;
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
        try {
            blockrendererdispatcher.func_175018_a(blockState, pos, access, buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ForgeHooksClient.setRenderLayer(null);
    }
}

