/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.sieve;

import com.google.common.collect.HashMultiset;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipe;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.SieveRegistry;
import exnihilocreatio.registries.types.Siftable;
import exnihilocreatio.util.ItemUtil;
import exnihilocreatio.util.StringUtils;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SieveRecipeCategory
implements IRecipeCategory<SieveRecipe> {
    public static final String UID = "exnihilocreatio:sieve";
    private static final ResourceLocation texture = new ResourceLocation("exnihilocreatio", "textures/gui/jei_mid.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;

    public SieveRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return "Sieve";
    }

    @Nonnull
    public String getModName() {
        return "exnihilocreatio";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, final @Nonnull SieveRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 10, 38);
        recipeLayout.getItemStacks().set(0, recipeWrapper.getMesh());
        recipeLayout.getItemStacks().init(1, true, 10, 2);
        recipeLayout.getItemStacks().set(1, recipeWrapper.getSievables());
        IFocus focus = recipeLayout.getFocus();
        int slotIndex = 2;
        for (int i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
            int slotX = 38 + i % 7 * 18;
            int slotY = 2 + i / 7 * 18;
            ItemStack outputStack = (ItemStack)recipeWrapper.getOutputs().get(i);
            recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
            recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
            if (focus == null) continue;
            ItemStack focusStack = (ItemStack)focus.getValue();
            if (focus.getMode() != IFocus.Mode.OUTPUT || focusStack.func_190926_b() || focusStack.func_77973_b() != outputStack.func_77973_b() || focusStack.func_77952_i() != outputStack.func_77952_i()) continue;
            recipeLayout.getItemStacks().setBackground(slotIndex + i, (IDrawable)this.slotHighlight);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            @SideOnly(value=Side.CLIENT)
            public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
                if (!input) {
                    ItemStack mesh = recipeWrapper.getMesh();
                    HashMultiset condensedTooltips = HashMultiset.create();
                    for (Siftable siftable : ExNihiloRegistryManager.SIEVE_REGISTRY.getDrops(recipeWrapper.getSievables().get(0))) {
                        ItemStack sifted;
                        if (!SieveRegistry.canSieve(siftable.getMeshLevel(), mesh.func_77952_i()) || !ItemUtil.areStacksEquivalent(sifted = siftable.getDrop().getItemStack(), ingredient)) continue;
                        condensedTooltips.add((Object)StringUtils.formatPercent(siftable.getChance()));
                    }
                    tooltip.add(I18n.func_135052_a((String)"jei.sieve.dropChance", (Object[])new Object[0]));
                    for (String line : condensedTooltips.elementSet()) {
                        tooltip.add(" * " + condensedTooltips.count((Object)line) + "x " + line);
                    }
                }
            }
        });
    }

    public IDrawable getIcon() {
        return null;
    }
}

