/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.LogUtil;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/json/CustomItemInfoJson;", "Lcom/google/gson/JsonDeserializer;", "Lexnihilocreatio/util/ItemInfo;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "exnihilocreatio"})
public final class CustomItemInfoJson
implements JsonDeserializer<ItemInfo>,
JsonSerializer<ItemInfo> {
    public static final CustomItemInfoJson INSTANCE;

    @NotNull
    public JsonElement serialize(@NotNull ItemInfo src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        JsonObject jsonObject;
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        NBTTagCompound nbt = src.getNbt();
        if (nbt == null || nbt.func_82582_d()) {
            StringBuilder stringBuilder = new StringBuilder();
            Item item = src.getItem();
            Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"src.item");
            ResourceLocation resourceLocation = item.getRegistryName();
            if (resourceLocation == null) {
                Intrinsics.throwNpe();
            }
            return (JsonElement)new JsonPrimitive(stringBuilder.append(resourceLocation.toString()).append(":").append(src.getMeta()).toString());
        }
        JsonObject $receiver = jsonObject = new JsonObject();
        Item item = src.getItem();
        Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"src.item");
        ResourceLocation resourceLocation = item.getRegistryName();
        if (resourceLocation == null) {
            Intrinsics.throwNpe();
        }
        $receiver.add("name", context.serialize((Object)resourceLocation.toString()));
        $receiver.add("meta", context.serialize((Object)src.getMeta()));
        $receiver.add("nbt", context.serialize((Object)String.valueOf(src.getNbt())));
        return (JsonElement)jsonObject;
    }

    @NotNull
    public ItemInfo deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (json.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"json.asJsonPrimitive");
            if (jsonPrimitive.isString()) {
                String name = json.getAsString();
                return new ItemInfo(name);
            }
        }
        JsonHelper helper = new JsonHelper(json);
        String name = helper.getString("name");
        int meta = helper.getNullableInteger("meta", 0);
        Item item = Item.func_111206_d((String)name);
        NBTTagCompound nbt = null;
        if (json.getAsJsonObject().has("nbt")) {
            try {
                JsonElement jsonElement = json.getAsJsonObject().get("nbt");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json.asJsonObject.get(\"nbt\")");
                nbt = JsonToNBT.func_180713_a((String)jsonElement.getAsString());
            }
            catch (NBTException e) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not convert JSON to NBT: ");
                JsonElement jsonElement = json.getAsJsonObject().get("nbt");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json.asJsonObject.get(\"nbt\")");
                LogUtil.error(stringBuilder.append(jsonElement.getAsString()).toString(), e);
                e.printStackTrace();
            }
        }
        if (item == null) {
            LogUtil.error("Error parsing JSON: Invalid Item: " + json);
            LogUtil.error("This may result in crashing or other undefined behavior");
            ItemInfo itemInfo = ItemInfo.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemInfo, (String)"ItemInfo.EMPTY");
            return itemInfo;
        }
        return new ItemInfo(item, meta, nbt);
    }

    private CustomItemInfoJson() {
    }

    static {
        CustomItemInfoJson customItemInfoJson;
        INSTANCE = customItemInfoJson = new CustomItemInfoJson();
    }
}

