/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.api.registries.ICompostRegistry;
import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipe;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomColorJson;
import exnihilocreatio.json.CustomCompostableJson;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Compostable;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.LogUtil;
import exnihilocreatio.util.StackInfo;
import exnihilocreatio.util.Util;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CompostRegistry
extends BaseRegistryMap<Ingredient, Compostable>
implements ICompostRegistry {
    protected final Map<Ingredient, Compostable> oreRegistry = new HashMap<Ingredient, Compostable>();

    public CompostRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Ingredient.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(OreIngredientStoring.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(Compostable.class, (Object)CustomCompostableJson.INSTANCE).registerTypeAdapter(Color.class, (Object)CustomColorJson.INSTANCE).registerTypeAdapter(BlockInfo.class, (Object)CustomBlockInfoJson.INSTANCE).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, Compostable>>(){}.getType(), ExNihiloRegistryManager.COMPOST_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(@NotNull ItemStack itemStack, float value, @NotNull BlockInfo state, @NotNull Color color) {
        if (itemStack.func_190926_b()) {
            return;
        }
        Ingredient ingredient = CraftingHelper.getIngredient((Object)itemStack);
        if (((Map)this.registry).keySet().stream().anyMatch(entry -> entry.test((Object)itemStack))) {
            LogUtil.error("Compost Entry for " + itemStack.func_77973_b().getRegistryName() + " with meta " + itemStack.func_77960_j() + " already exists, skipping.");
            return;
        }
        Compostable compostable = new Compostable(value, color, state);
        this.register(ingredient, compostable);
    }

    @Override
    public void register(Item item, int meta, float value, @NotNull BlockInfo state, @NotNull Color color) {
        this.register(new ItemStack(item, 1, meta), value, state, color);
    }

    @Override
    public void register(@NotNull Block block, int meta, float value, @NotNull BlockInfo state, @NotNull Color color) {
        this.register(new ItemStack(block, 1, meta), value, state, color);
    }

    @Override
    public void register(@NotNull StackInfo item, float value, @NotNull BlockInfo state, @NotNull Color color) {
        this.register(item.getItemStack(), value, state, color);
    }

    @Override
    public void register(@NotNull ResourceLocation location, int meta, float value, @NotNull BlockInfo state, @NotNull Color color) {
        this.register((Item)ForgeRegistries.ITEMS.getValue(location), meta, value, state, color);
    }

    @Override
    public void register(@NotNull String name, float value, @NotNull BlockInfo state, @NotNull Color color) {
        OreIngredientStoring ingredient = new OreIngredientStoring(name);
        Compostable compostable = new Compostable(value, color, state);
        if (this.oreRegistry.keySet().stream().anyMatch(arg_0 -> CompostRegistry.lambda$register$1((Ingredient)ingredient, arg_0))) {
            LogUtil.error("Compost Ore Entry for " + name + " already exists, skipping.");
        } else {
            this.register(ingredient, compostable);
        }
    }

    @Override
    public void register(@NotNull String name, float value, @NotNull BlockInfo state) {
        this.register(name, value, state, Color.INVALID_COLOR);
    }

    @Override
    @NotNull
    public Compostable getItem(@NotNull Item item, int meta) {
        return this.getItem(new ItemStack(item, meta));
    }

    @Override
    @NotNull
    public Compostable getItem(@NotNull ItemStack stack) {
        Ingredient ingredient = ((Map)this.registry).keySet().stream().filter(entry -> entry.test((Object)stack)).findFirst().orElse(null);
        if (ingredient != null) {
            return (Compostable)((Map)this.registry).get(ingredient);
        }
        ingredient = this.oreRegistry.keySet().stream().filter(entry -> entry.test((Object)stack)).findFirst().orElse(null);
        if (ingredient != null) {
            return this.oreRegistry.get(ingredient);
        }
        return Compostable.Companion.getEMPTY();
    }

    @Override
    @NotNull
    public Compostable getItem(@NotNull StackInfo info) {
        return this.getItem(info.getItemStack());
    }

    @Override
    public boolean containsItem(@NotNull Item item, int meta) {
        return this.containsItem(new ItemStack(item, meta));
    }

    @Override
    public boolean containsItem(@NotNull ItemStack stack) {
        return ((Map)this.registry).keySet().stream().anyMatch(entry -> entry.test((Object)stack)) || this.oreRegistry.keySet().stream().anyMatch(entry -> entry.test((Object)stack));
    }

    @Override
    public boolean containsItem(@NotNull StackInfo info) {
        return this.containsItem(info.getItemStack());
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        Map gsonInput = (Map)this.gson.fromJson((Reader)fr, new TypeToken<Map<String, Compostable>>(){}.getType());
        for (Map.Entry entry : gsonInput.entrySet()) {
            Ingredient ingr = IngredientUtil.parseFromString((String)entry.getKey());
            if (((Map)this.registry).keySet().stream().anyMatch(ingredient -> IngredientUtil.ingredientEquals(ingredient, ingr))) {
                LogUtil.error("Compost JSON Entry for " + (String)entry.getKey() + " already exists, skipping.");
                continue;
            }
            this.register(ingr, entry.getValue());
        }
    }

    @Override
    public Map<Ingredient, Compostable> getRegistry() {
        HashMap map = (HashMap)((HashMap)this.registry).clone();
        map.putAll(this.oreRegistry);
        return map;
    }

    @Override
    public List<CompostRecipe> getRecipeList() {
        ArrayList<CompostRecipe> recipes = new ArrayList<CompostRecipe>();
        HashMap outputMap = new HashMap();
        for (Map.Entry entry : this.getRegistry().entrySet()) {
            ArrayList<ItemStack> inputs;
            BlockInfo output = ((Compostable)entry.getValue()).getCompostBlock();
            Ingredient ingredient = (Ingredient)entry.getKey();
            if (ingredient == null || !output.isValid()) continue;
            if (!outputMap.containsKey(output)) {
                inputs = new ArrayList<ItemStack>();
                outputMap.put(output, inputs);
            }
            inputs = new ArrayList();
            for (ItemStack match : ingredient.func_193365_a()) {
                if (match.func_190926_b()) continue;
                ItemStack input = match.func_77946_l();
                input.func_190920_e(Util.stepsRequiredToMatch(1.0f, ((Compostable)entry.getValue()).getValue()));
                inputs.add(input);
            }
            if (inputs.size() <= 0) continue;
            ((List)outputMap.get(output)).add(inputs);
        }
        for (Map.Entry entry : outputMap.entrySet()) {
            for (int i = 0; i < ((List)entry.getValue()).size(); i += 21) {
                recipes.add(new CompostRecipe((BlockInfo)entry.getKey(), ((List)entry.getValue()).subList(i, Math.min(i + 21, ((List)entry.getValue()).size()))));
            }
        }
        return recipes;
    }

    private static /* synthetic */ boolean lambda$register$1(Ingredient ingredient, Ingredient entry) {
        return IngredientUtil.ingredientEquals(entry, ingredient);
    }
}

