/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.api.registries.IFluidItemFluidRegistry;
import exnihilocreatio.compatibility.jei.barrel.fluiditemtransform.FluidItemTransformRecipe;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryList;
import exnihilocreatio.registries.types.FluidItemFluid;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.StackInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.NotNull;

public class FluidItemFluidRegistry
extends BaseRegistryList<FluidItemFluid>
implements IFluidItemFluidRegistry {
    public FluidItemFluidRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)CustomItemInfoJson.INSTANCE).registerTypeAdapter(StackInfo.class, (Object)CustomItemInfoJson.INSTANCE).registerTypeAdapter(BlockInfo.class, (Object)CustomBlockInfoJson.INSTANCE).create(), ExNihiloRegistryManager.FLUID_ITEM_FLUID_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(@NotNull String inputFluid, @NotNull StackInfo reactant, @NotNull String outputFluid) {
        ((List)this.registry).add(new FluidItemFluid(inputFluid, reactant, outputFluid));
    }

    @Override
    public void register(@NotNull Fluid inputFluid, @NotNull StackInfo reactant, @NotNull Fluid outputFluid) {
        ((List)this.registry).add(new FluidItemFluid(inputFluid.getName(), reactant, outputFluid.getName()));
    }

    @Override
    public String getFLuidForTransformation(@NotNull Fluid fluid, @NotNull ItemStack stack) {
        ItemInfo info = new ItemInfo(stack);
        for (FluidItemFluid transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getInputFluid()) || !info.equals(transformer.getReactant())) continue;
            return transformer.getOutput();
        }
        return null;
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        List gsonInput = (List)this.gson.fromJson((Reader)fr, new TypeToken<List<FluidItemFluid>>(){}.getType());
        ((List)this.registry).addAll(gsonInput);
    }

    @Override
    public List<FluidItemTransformRecipe> getRecipeList() {
        return ((List)this.registry).stream().filter(it -> FluidRegistry.isFluidRegistered((String)it.getInputFluid())).filter(it -> FluidRegistry.isFluidRegistered((String)it.getOutput())).map(FluidItemTransformRecipe::new).collect(Collectors.toList());
    }
}

