/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.api.registries.IMilkEntityRegistry;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryList;
import exnihilocreatio.registries.types.Milkable;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class MilkEntityRegistry
extends BaseRegistryList<Milkable>
implements IMilkEntityRegistry {
    public MilkEntityRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)CustomItemInfoJson.INSTANCE).registerTypeAdapter(BlockInfo.class, (Object)CustomBlockInfoJson.INSTANCE).create(), ExNihiloRegistryManager.MILK_ENTITY_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(@NotNull Entity entityOnTop, @NotNull Fluid result, int amount, int coolDown) {
        ((List)this.registry).add(new Milkable(EntityList.func_191301_a((Entity)entityOnTop).toString(), result.getName(), amount, coolDown));
    }

    @Override
    public void register(@NotNull String entityOnTop, @NotNull String result, int amount, int coolDown) {
        ((List)this.registry).add(new Milkable(entityOnTop.toLowerCase(), result, amount, coolDown));
    }

    @Override
    public boolean isValidRecipe(Entity entityOnTop) {
        return entityOnTop != null && this.isValidRecipe(entityOnTop.func_70005_c_());
    }

    @Override
    public boolean isValidRecipe(String entityOnTop) {
        if (entityOnTop == null) {
            return false;
        }
        for (Milkable milk : (List)this.registry) {
            if (!milk.getEntityOnTop().equals(entityOnTop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Milkable getMilkable(Entity entityOnTop) {
        if (entityOnTop == null || EntityList.func_191301_a((Entity)entityOnTop) == null) {
            return null;
        }
        String entityKey = EntityList.func_191301_a((Entity)entityOnTop).toString();
        for (Milkable milk : (List)this.registry) {
            if (entityKey.equals(milk.getEntityOnTop().toLowerCase())) {
                return milk;
            }
            if (milk.getEntityOnTop().contains(":") || !entityKey.equals("minecraft:" + milk.getEntityOnTop().toLowerCase())) continue;
            return milk;
        }
        return null;
    }

    @Override
    public String getResult(@NotNull Entity entityOnTop) {
        Milkable milk = this.getMilkable(entityOnTop);
        if (milk != null) {
            return milk.getResult();
        }
        return null;
    }

    @Override
    public int getAmount(@NotNull Entity entityOnTop) {
        Milkable milk = this.getMilkable(entityOnTop);
        if (milk != null) {
            return milk.getAmount();
        }
        return 0;
    }

    @Override
    public int getCoolDown(@NotNull Entity entityOnTop) {
        Milkable milk = this.getMilkable(entityOnTop);
        if (milk != null) {
            return milk.getCoolDown();
        }
        return 0;
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        List gsonInput = (List)this.gson.fromJson((Reader)fr, new TypeToken<List<Milkable>>(){}.getType());
        ((List)this.registry).addAll(gsonInput);
    }

    @Override
    public List<?> getRecipeList() {
        return Lists.newLinkedList();
    }
}

