/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.ModItems;
import exnihilocreatio.api.registries.ISieveRegistry;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipe;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Siftable;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.StackInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SieveRegistry
extends BaseRegistryMap<Ingredient, List<Siftable>>
implements ISieveRegistry {
    public SieveRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Ingredient.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(OreIngredientStoring.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(ItemInfo.class, (Object)CustomItemInfoJson.INSTANCE).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, List<Siftable>>>(){}.getType(), ExNihiloRegistryManager.SIEVE_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(@NotNull ItemStack itemStack, @NotNull StackInfo drop, float chance, int meshLevel) {
        if (itemStack.func_190926_b()) {
            return;
        }
        if (drop instanceof ItemInfo) {
            this.register(CraftingHelper.getIngredient((Object)itemStack), new Siftable((ItemInfo)drop, chance, meshLevel));
        } else {
            this.register(CraftingHelper.getIngredient((Object)itemStack), new Siftable(new ItemInfo(drop.getItemStack()), chance, meshLevel));
        }
    }

    @Override
    public void register(@NotNull Item item, int meta, @NotNull StackInfo drop, float chance, int meshLevel) {
        this.register(new ItemStack(item, 1, meta), drop, chance, meshLevel);
    }

    @Override
    public void register(@NotNull StackInfo item, @NotNull StackInfo drop, float chance, int meshLevel) {
        this.register(item.getItemStack(), drop, chance, meshLevel);
    }

    @Override
    public void register(@NotNull Block block, int meta, @NotNull StackInfo drop, float chance, int meshLevel) {
        this.register(new ItemStack(block, 1, meta), drop, chance, meshLevel);
    }

    @Override
    public void register(@NotNull IBlockState state, @NotNull StackInfo drop, float chance, int meshLevel) {
        this.register(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), drop, chance, meshLevel);
    }

    @Override
    public void register(@NotNull ResourceLocation location, int meta, @NotNull StackInfo drop, float chance, int meshLevel) {
        this.register(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(location), 1, meta), drop, chance, meshLevel);
    }

    @Override
    public void register(@NotNull String name, @NotNull StackInfo drop, float chance, int meshLevel) {
        if (drop instanceof ItemInfo) {
            this.register((Ingredient)new OreIngredientStoring(name), new Siftable((ItemInfo)drop, chance, meshLevel));
        } else {
            this.register((Ingredient)new OreIngredientStoring(name), new Siftable(new ItemInfo(drop.getItemStack()), chance, meshLevel));
        }
    }

    @Override
    public void register(@NotNull Ingredient ingredient, @NotNull Siftable drop) {
        if (ingredient == null) {
            return;
        }
        Ingredient search = ((Map)this.registry).keySet().stream().filter(entry -> IngredientUtil.ingredientEquals(entry, ingredient)).findAny().orElse(null);
        if (search != null) {
            ((List)((Map)this.registry).get(search)).add(drop);
        } else {
            NonNullList drops = NonNullList.func_191196_a();
            drops.add((Object)drop);
            super.register(ingredient, drops);
        }
    }

    @Override
    @NotNull
    public List<Siftable> getDrops(@NotNull StackInfo stack) {
        return this.getDrops(stack.getItemStack());
    }

    @Override
    @NotNull
    public List<Siftable> getDrops(@NotNull ItemStack stack) {
        ArrayList<Siftable> drops = new ArrayList<Siftable>();
        if (!stack.func_190926_b()) {
            ((Map)this.registry).entrySet().stream().filter(entry -> ((Ingredient)entry.getKey()).test((Object)stack)).forEach(entry -> drops.addAll((Collection)entry.getValue()));
        }
        return drops;
    }

    @Override
    @NotNull
    public List<Siftable> getDrops(@NotNull Ingredient ingredient) {
        ArrayList<Siftable> drops = new ArrayList<Siftable>();
        ((Map)this.registry).entrySet().stream().filter(entry -> entry.getKey() == ingredient).forEach(entry -> drops.addAll((Collection)entry.getValue()));
        return drops;
    }

    @Override
    @NotNull
    public List<ItemStack> getRewardDrops(@NotNull Random random, @NotNull IBlockState block, int meshLevel, int fortuneLevel) {
        if (block == null) {
            return null;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.getDrops(new BlockInfo(block)).forEach(siftable -> {
            if (SieveRegistry.canSieve(siftable.getMeshLevel(), meshLevel)) {
                int triesWithFortune = Math.max(random.nextInt(fortuneLevel + 2), 1);
                for (int i = 0; i < triesWithFortune; ++i) {
                    if (!(random.nextDouble() < (double)siftable.getChance())) continue;
                    drops.add(siftable.getDrop().getItemStack());
                }
            }
        });
        return drops;
    }

    @Override
    public boolean canBeSifted(@NotNull ItemStack stack) {
        return !stack.func_190926_b() && ((Map)this.registry).keySet().stream().anyMatch(entry -> entry.test((Object)stack));
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<Ingredient, ArrayList<Siftable>>>(){}.getType());
        for (Map.Entry input : gsonInput.entrySet()) {
            Ingredient key = (Ingredient)input.getKey();
            if (key == null || key == Ingredient.field_193370_a) continue;
            for (Siftable siftable : (ArrayList)input.getValue()) {
                if (!siftable.getDrop().isValid()) continue;
                this.register(key, siftable);
            }
        }
    }

    @Override
    public List<SieveRecipe> getRecipeList() {
        ArrayList<SieveRecipe> sieveRecipes = new ArrayList<SieveRecipe>();
        for (Ingredient ingredient : ((Map)this.getRegistry()).keySet()) {
            if (ingredient == null) continue;
            for (BlockSieve.MeshType meshType : BlockSieve.MeshType.values()) {
                ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
                inputs.add(Collections.singletonList(new ItemStack((Item)ModItems.mesh, 1, meshType.getID())));
                inputs.add(Arrays.asList(ingredient.func_193365_a()));
                if (!meshType.isValid()) continue;
                List rawOutputs = ((List)((Map)this.getRegistry()).get(ingredient)).stream().filter(reward -> SieveRegistry.canSieve(reward.getMeshLevel(), meshType)).map(reward -> reward.getDrop().getItemStack()).collect(Collectors.toList());
                ArrayList allOutputs = Lists.newArrayList();
                for (ItemStack raw : rawOutputs) {
                    boolean alreadyExists = false;
                    for (ItemStack all : allOutputs) {
                        if (!ItemStack.func_179545_c((ItemStack)raw, (ItemStack)all) || !ItemStack.func_77970_a((ItemStack)raw, (ItemStack)all)) continue;
                        all.func_190917_f(raw.func_190916_E());
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    allOutputs.add(raw);
                }
                for (int i = 0; i < allOutputs.size(); i += 21) {
                    List<ItemStack> outputs = allOutputs.subList(i, Math.min(i + 21, allOutputs.size()));
                    sieveRecipes.add(new SieveRecipe(inputs, outputs));
                }
            }
        }
        return sieveRecipes;
    }

    public static boolean canSieve(int dropLevel, BlockSieve.MeshType meshType) {
        return SieveRegistry.canSieve(dropLevel, meshType.getID());
    }

    public static boolean canSieve(int dropLevel, int meshLevel) {
        return ModConfig.sieve.flattenSieveRecipes ? meshLevel >= dropLevel : meshLevel == dropLevel;
    }
}

