/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.util;

import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.LogUtil;
import exnihilocreatio.util.StackInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemInfo
implements StackInfo {
    public static final ItemInfo EMPTY = new ItemInfo(ItemStack.field_190927_a);
    @Nonnull
    private final Item item;
    private int meta = 0;
    @Nullable
    private NBTTagCompound nbt = null;
    private boolean isWildcard = false;

    public ItemInfo(@Nonnull Item item) {
        this.item = item;
        this.checkWildcard();
    }

    public ItemInfo(@Nonnull Item item, int meta) {
        this.item = item;
        if (meta == -1 || meta == Short.MAX_VALUE) {
            this.isWildcard = true;
        } else {
            this.meta = meta;
            this.checkWildcard();
        }
    }

    public ItemInfo(@Nonnull ItemStack stack) {
        this.item = stack.func_77973_b();
        this.meta = stack.func_77952_i();
        this.nbt = stack.func_77978_p();
        this.checkWildcard();
    }

    public ItemInfo(@Nonnull Block block) {
        this.item = Item.func_150898_a((Block)block);
        this.checkWildcard();
    }

    public ItemInfo(@Nonnull Block block, int blockMeta) {
        this(block, blockMeta, null);
    }

    public ItemInfo(@Nonnull Block block, int blockMeta, @Nullable NBTTagCompound tag) {
        this(Item.func_150898_a((Block)block), blockMeta, tag);
    }

    public ItemInfo(@Nonnull Item item, int meta, @Nullable NBTTagCompound tag) {
        this.item = item;
        if (tag != null) {
            this.nbt = tag.func_74737_b();
        }
        if (this.item == Items.field_190931_a) {
            this.isWildcard = true;
        } else if (meta == -1 || meta == Short.MAX_VALUE) {
            this.isWildcard = true;
        } else {
            this.meta = meta;
            this.checkWildcard();
        }
    }

    public ItemInfo(@Nonnull Item item, int meta, @Nonnull String tag) {
        this.item = item;
        if (this.item == Items.field_190931_a) {
            this.isWildcard = true;
        } else if (meta == -1 || meta == Short.MAX_VALUE) {
            this.isWildcard = true;
        } else {
            this.meta = meta;
            this.checkWildcard();
        }
        try {
            this.nbt = JsonToNBT.func_180713_a((String)tag);
        }
        catch (NBTException e) {
            LogUtil.error("Could not parse NBTTag: " + tag);
            this.nbt = new NBTTagCompound();
        }
    }

    public ItemInfo(@Nonnull String string) {
        if (string.isEmpty() || string.length() < 2) {
            this.item = Items.field_190931_a;
            this.isWildcard = true;
            return;
        }
        String[] split = string.split(":");
        Item item = null;
        int meta = 0;
        switch (split.length) {
            case 1: {
                item = Item.func_111206_d((String)("minecraft:" + split[0]));
                break;
            }
            case 2: {
                try {
                    meta = split[1].equals("*") ? -1 : Integer.parseInt(split[1]);
                    item = Item.func_111206_d((String)("minecraft:" + split[0]));
                }
                catch (NumberFormatException e) {
                    this.isWildcard = true;
                    meta = 0;
                    item = Item.func_111206_d((String)(split[0] + ":" + split[1]));
                }
                break;
            }
            case 3: {
                try {
                    meta = split[2].equals("*") ? -1 : Integer.parseInt(split[2]);
                    item = Item.func_111206_d((String)(split[0] + ":" + split[1]));
                }
                catch (NumberFormatException e) {
                    meta = 0;
                    this.isWildcard = true;
                }
                break;
            }
            default: {
                this.item = Items.field_190931_a;
                this.isWildcard = true;
                return;
            }
        }
        if (item == null) {
            this.item = Items.field_190931_a;
            this.isWildcard = true;
        } else {
            this.item = item;
            if (meta == -1 || meta == Short.MAX_VALUE) {
                this.isWildcard = true;
            } else {
                this.meta = meta;
                this.checkWildcard();
            }
        }
    }

    public ItemInfo(@Nonnull IBlockState state) {
        this.item = Item.func_150898_a((Block)state.func_177230_c());
        this.meta = state.func_177230_c().func_176201_c(state);
    }

    public static ItemInfo readFromNBT(NBTTagCompound tag) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("item")));
        int meta = tag.func_74762_e("meta");
        if (tag.func_74764_b("nbt")) {
            return item == null ? EMPTY : new ItemInfo(item, meta, tag.func_74775_l("nbt"));
        }
        return item == null ? EMPTY : new ItemInfo(item, meta);
    }

    private void checkWildcard() {
        NonNullList subItems = NonNullList.func_191196_a();
        this.item.func_150895_a(this.item.func_77640_w() == null ? CreativeTabs.field_78027_g : this.item.func_77640_w(), subItems);
        if (subItems.size() <= 1) {
            this.isWildcard = true;
        }
    }

    @Override
    public String toString() {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item) + (this.meta == 0 ? "" : ":" + this.meta);
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        if (this.item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(this.item, 1, this.meta);
        if (this.nbt != null) {
            stack.func_77982_d(this.nbt);
        }
        return stack;
    }

    @Override
    public boolean hasBlock() {
        return this.item instanceof ItemBlock;
    }

    @Override
    @Nonnull
    public Block getBlock() {
        return Block.func_149634_a((Item)this.item);
    }

    @Override
    @Nonnull
    public IBlockState getBlockState() {
        if (this.item == Items.field_190931_a) {
            return Blocks.field_150350_a.func_176223_P();
        }
        try {
            return Block.func_149634_a((Item)this.item).func_176203_a(this.meta);
        }
        catch (Exception e) {
            return Block.func_149634_a((Item)this.item).func_176223_P();
        }
    }

    @Override
    public int getMeta() {
        return this.isWildcard ? -1 : this.meta;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item);
        tag.func_74778_a("item", key == null ? "" : key.toString());
        tag.func_74768_a("meta", this.meta);
        if (this.nbt != null && !this.nbt.func_82582_d()) {
            tag.func_74782_a("nbt", (NBTBase)this.nbt);
        }
        return tag;
    }

    @Override
    public boolean isValid() {
        return this.item != Items.field_190931_a && this.meta <= Short.MAX_VALUE;
    }

    @Override
    public int hashCode() {
        return this.item.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this.isWildcard) {
            if (obj instanceof ItemInfo) {
                return ItemStack.func_185132_d((ItemStack)((ItemInfo)obj).getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof ItemStack) {
                return ItemStack.func_185132_d((ItemStack)((ItemStack)obj), (ItemStack)this.getItemStack());
            }
            if (obj instanceof BlockInfo) {
                return ItemStack.func_185132_d((ItemStack)((BlockInfo)obj).getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof Block) {
                BlockInfo block = new BlockInfo((Block)obj);
                return ItemStack.func_185132_d((ItemStack)block.getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof Item) {
                ItemInfo item = new ItemInfo((Item)obj);
                return ItemStack.func_185132_d((ItemStack)item.getItemStack(), (ItemStack)this.getItemStack());
            }
        } else {
            if (obj instanceof ItemInfo) {
                return ItemStack.func_77989_b((ItemStack)((ItemInfo)obj).getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof ItemStack) {
                return ItemStack.func_77989_b((ItemStack)((ItemStack)obj), (ItemStack)this.getItemStack());
            }
            if (obj instanceof BlockInfo) {
                return ItemStack.func_77989_b((ItemStack)((BlockInfo)obj).getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof Block) {
                BlockInfo block = new BlockInfo((Block)obj);
                return ItemStack.func_77989_b((ItemStack)block.getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof Item) {
                ItemInfo item = new ItemInfo((Item)obj);
                return ItemStack.func_77989_b((ItemStack)item.getItemStack(), (ItemStack)this.getItemStack());
            }
        }
        return false;
    }

    @Nonnull
    public Item getItem() {
        return this.item;
    }

    @Nullable
    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }
}

