/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

final class CachedProperty<T> {
    private T value;
    private final T invalid;
    private boolean valid;
    private long timestamp;
    private final long validity;

    CachedProperty(long validity, T invalid) {
        this.validity = validity;
        this.invalid = invalid;
    }

    T get() {
        return this.valid ? this.value : this.invalid;
    }

    boolean check() {
        if (System.currentTimeMillis() - this.timestamp > this.validity) {
            this.invalidate();
        }
        return this.valid;
    }

    void invalidate() {
        this.valid = false;
    }

    void set(T value) {
        this.value = value;
        this.timestamp = System.currentTimeMillis();
        this.valid = true;
    }
}

