/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.MemoryCardBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class MemoryCardModel
implements IModel {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "item/memory_card");
    private static final ResourceLocation TEXTURE = new ResourceLocation("appliedenergistics2", "items/memory_card_hash");

    public Collection<ResourceLocation> getDependencies() {
        return Collections.singletonList(MODEL_BASE);
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.singletonList(TEXTURE);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite texture = bakedTextureGetter.apply(TEXTURE);
        IBakedModel baseModel = this.getBaseModel(state, format, bakedTextureGetter);
        return new MemoryCardBakedModel(format, baseModel, texture);
    }

    private IBakedModel getBaseModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)MODEL_BASE).bake(state, format, bakedTextureGetter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity().toItemTransform();
    }
}

