/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.AEBaseContainer;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;

public class PacketTargetItemStack
extends AppEngPacket {
    private AEItemStack stack;

    public PacketTargetItemStack(ByteBuf stream) {
        try {
            this.stack = stream.readableBytes() > 0 ? AEItemStack.fromPacket(stream) : null;
        }
        catch (Exception ex) {
            AELog.debug(ex);
            this.stack = null;
        }
    }

    public PacketTargetItemStack(AEItemStack stack) {
        this.stack = stack;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        if (stack != null) {
            try {
                stack.writeToPacket(data);
            }
            catch (Exception ex) {
                AELog.debug(ex);
            }
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        if (player.field_71070_bA instanceof AEBaseContainer) {
            ((AEBaseContainer)player.field_71070_bA).setTargetStack(this.stack);
        }
    }
}

