/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import javax.vecmath.Matrix4f;
import net.malisis.core.block.IComponent;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;

public class ItemTransformComponent
implements IComponent {
    protected Matrix4f thirdPersonLeftHand;
    protected Matrix4f thirdPersonRightHand;
    protected Matrix4f firstPersonLeftHand;
    protected Matrix4f firstPersonRightHand;
    protected Matrix4f head;
    protected Matrix4f gui;
    protected Matrix4f ground;
    protected Matrix4f fixed;

    @Override
    public boolean isClientComponent() {
        return true;
    }

    public ItemTransformComponent thirdPerson(Matrix4f left, Matrix4f right) {
        this.thirdPersonLeftHand = left;
        this.thirdPersonRightHand = right;
        return this;
    }

    public ItemTransformComponent firstPerson(Matrix4f left, Matrix4f right) {
        this.firstPersonLeftHand = left;
        this.firstPersonRightHand = right;
        return this;
    }

    public ItemTransformComponent head(Matrix4f head) {
        this.head = head;
        return this;
    }

    public ItemTransformComponent gui(Matrix4f gui) {
        this.gui = gui;
        return this;
    }

    public ItemTransformComponent ground(Matrix4f ground) {
        this.ground = ground;
        return this;
    }

    public ItemTransformComponent fixed(Matrix4f fixed) {
        this.fixed = fixed;
        return this;
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType transformType) {
        switch (transformType) {
            case THIRD_PERSON_LEFT_HAND: {
                return this.thirdPersonLeftHand;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                return this.thirdPersonRightHand;
            }
            case FIRST_PERSON_LEFT_HAND: {
                return this.firstPersonLeftHand;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                return this.firstPersonRightHand;
            }
            case HEAD: {
                return this.head;
            }
            case GUI: {
                return this.gui;
            }
            case GROUND: {
                return this.ground;
            }
            case FIXED: {
                return this.fixed;
            }
        }
        return null;
    }
}

