/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.BasicContainer;
import net.malisis.core.client.gui.component.container.BasicList;
import net.malisis.core.client.gui.component.decoration.BasicLine;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.util.TriFunction;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BasicDualListContainer<T>
extends BasicContainer<BasicDualListContainer<T>> {
    private final TriFunction<MalisisGui, BasicList<T>, T, ? extends BasicList.ItemComponent<?>> leftComponentFactory;
    private final TriFunction<MalisisGui, BasicList<T>, T, ? extends BasicList.ItemComponent<?>> rightComponentFactory;
    private final String leftTitle;
    private final String rightTitle;
    protected BasicContainer<?> leftContainer;
    protected BasicContainer<?> middleContainer;
    protected BasicContainer<?> rightContainer;
    protected BasicList<T> leftDynamicList;
    protected BasicList<T> rightDynamicList;

    public BasicDualListContainer(MalisisGui gui, int width, int height, String leftTitle, String rightTitle, TriFunction<MalisisGui, BasicList<T>, T, ? extends BasicList.ItemComponent<?>> leftComponentFactory, TriFunction<MalisisGui, BasicList<T>, T, ? extends BasicList.ItemComponent<?>> rightComponentFactory) {
        super(gui, width, height);
        this.leftTitle = leftTitle;
        this.rightTitle = rightTitle;
        this.leftDynamicList = new BasicList(gui, 0, 0);
        this.rightDynamicList = new BasicList(gui, 0, 0);
        this.leftComponentFactory = leftComponentFactory;
        this.rightComponentFactory = rightComponentFactory;
    }

    protected void construct(MalisisGui gui) {
        this.setBorder(0xFFFFFF, 1, 185);
        this.setBackgroundAlpha(0);
        this.middleContainer = this.createMiddleContainer(gui);
        int middleContainerWidth = this.middleContainer == null ? 0 : this.middleContainer.getWidth();
        this.leftContainer = new BasicContainer(gui, (this.width - middleContainerWidth - 5) / 2, 0);
        this.leftContainer.setBackgroundAlpha(0);
        this.leftContainer.setPadding(4, 4);
        this.leftContainer.setTopPadding(20);
        UILabel leftContainerLabel = new UILabel(gui, this.leftTitle);
        leftContainerLabel.setPosition(0, -15, Anchor.TOP | Anchor.CENTER);
        this.leftDynamicList.setItemComponentFactory(this.leftComponentFactory);
        this.leftDynamicList.setItemComponentSpacing(1);
        this.leftDynamicList.setCanDeselect(false);
        this.leftDynamicList.setName("list.left");
        this.leftDynamicList.register(this);
        this.leftContainer.add(leftContainerLabel, this.leftDynamicList);
        this.rightContainer = new BasicContainer(gui, (this.width - middleContainerWidth - 5) / 2, 0);
        this.rightContainer.setBackgroundAlpha(0);
        this.rightContainer.setPadding(4, 4);
        this.rightContainer.setTopPadding(20);
        this.rightContainer.setAnchor(Anchor.TOP | Anchor.RIGHT);
        UILabel rightContainerLabel = new UILabel(gui, this.rightTitle);
        rightContainerLabel.setPosition(0, -15, Anchor.TOP | Anchor.CENTER);
        this.rightDynamicList.setPosition(0, 0, Anchor.TOP | Anchor.RIGHT);
        this.rightDynamicList.setItemComponentFactory(this.rightComponentFactory);
        this.rightDynamicList.setItemComponentSpacing(1);
        this.rightDynamicList.setCanDeselect(false);
        this.rightDynamicList.setName("list.right");
        this.rightDynamicList.register(this);
        this.rightContainer.add(rightContainerLabel, this.rightDynamicList);
        BasicLine titleLine = new BasicLine(gui, this.getRawWidth() - (this.getLeftBorderSize() + this.getRightBorderSize()));
        titleLine.setPosition(0, BasicScreen.getPaddedY(leftContainerLabel, 2));
        this.add(this.leftContainer, this.middleContainer, this.rightContainer, titleLine);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        super.drawBackground(renderer, mouseX, mouseY, partialTick);
        int startX = this.width / 2;
        int middleContainerHeight = this.middleContainer == null ? 0 : this.middleContainer.getHeight();
        int halfHeight = (this.height - middleContainerHeight - this.getTopBorderSize()) / 2;
        int startY = 1;
        renderer.drawRectangle(this.getLeftBorderSize(), this.leftContainer.getTopPadding() - 4, 1, this.getRawWidth() - (this.getLeftBorderSize() + this.getRightBorderSize()), 1, 0xFFFFFF, 185);
        renderer.drawRectangle(startX, startY, 50, 1, halfHeight, 0xFFFFFF, 185);
        startY += halfHeight;
        renderer.drawRectangle(startX, startY += middleContainerHeight - 1, 50, 1, halfHeight, 0xFFFFFF, 185);
    }

    @Subscribe
    private void onItemSelect(BasicList.SelectEvent<T> event) {
        this.updateControls(event.getNewValue(), this.getSideFromList((BasicList)event.getComponent()));
    }

    public BasicDualListContainer<T> setItems(List<T> list, SideType target) {
        this.getListFromSide(target).setItems(list);
        this.fireEvent(new PopulateEvent(this, target));
        return this;
    }

    public Collection<T> getItems(SideType target) {
        return this.getListFromSide(target).getItems();
    }

    @Nullable
    protected BasicContainer<?> createMiddleContainer(MalisisGui gui) {
        return null;
    }

    protected BasicList<T> getListFromSide(SideType target) {
        if (target == SideType.LEFT) {
            return this.leftDynamicList;
        }
        return this.rightDynamicList;
    }

    protected BasicList<T> getOpposingListFromSide(SideType target) {
        if (target == SideType.LEFT) {
            return this.rightDynamicList;
        }
        return this.leftDynamicList;
    }

    protected SideType getSideFromList(BasicList<T> list) {
        return list.getName().equalsIgnoreCase("list.left") ? SideType.LEFT : SideType.RIGHT;
    }

    protected SideType getOpposingSideFromList(BasicList<T> list) {
        return list.getName().equalsIgnoreCase("list.left") ? SideType.RIGHT : SideType.LEFT;
    }

    protected SideType getOppositeSide(SideType side) {
        return side == SideType.LEFT ? SideType.RIGHT : SideType.LEFT;
    }

    protected void updateControls(@Nullable T selectedValue, SideType targetSide) {
        BasicList<T> targetList = this.getListFromSide(targetSide);
        targetList.unregister(this);
        targetList.setSelectedItem(null);
        targetList.register(this);
        this.fireEvent(new UpdateEvent(this));
    }

    public static class UpdateEvent<T>
    extends ComponentEvent<BasicDualListContainer<T>> {
        public UpdateEvent(BasicDualListContainer<T> component) {
            super(component);
        }
    }

    public static class PopulateEvent<T>
    extends ComponentEvent<BasicDualListContainer<T>> {
        public final SideType side;

        public PopulateEvent(BasicDualListContainer<T> component, SideType side) {
            super(component);
            this.side = side;
        }
    }

    public static enum SideType {
        LEFT,
        RIGHT;

    }
}

