/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.configuration.setting;

import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.configuration.setting.Setting;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BooleanSetting
extends Setting<Boolean> {
    private UICheckBox checkbox;

    public BooleanSetting(String key, boolean defaultValue) {
        super(key, defaultValue);
        this.type = Property.Type.BOOLEAN;
    }

    @Override
    public Boolean readValue(String stringValue) {
        return Boolean.parseBoolean(stringValue);
    }

    @Override
    public String writeValue(Boolean value) {
        return value.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public UICheckBox getComponent(MalisisGui gui) {
        this.checkbox = new UICheckBox(gui, this.key).setChecked((Boolean)this.value);
        return this.checkbox;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Boolean getValueFromComponent() {
        return this.checkbox.isChecked();
    }
}

