/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class SizeTransform<T>
extends Transformation<SizeTransform<T>, ITransformable.Size<T>> {
    protected int fromWidth;
    protected int fromHeight;
    protected int toWidth;
    protected int toHeight;

    public SizeTransform(int width, int height) {
        this.to(width, height);
    }

    public SizeTransform(int fromWidth, int fromHeight, int toWidth, int toHeight) {
        this.from(fromWidth, fromHeight);
        this.to(toWidth, toHeight);
    }

    @Override
    public SizeTransform<T> self() {
        return this;
    }

    public SizeTransform<T> from(int width, int height) {
        this.fromWidth = width;
        this.fromHeight = height;
        return this;
    }

    public SizeTransform<T> to(int width, int height) {
        this.toWidth = width;
        this.toHeight = height;
        return this;
    }

    @Override
    protected void doTransform(ITransformable.Size<T> transformable, float comp) {
        int fromWidth = this.reversed ? this.toWidth : this.fromWidth;
        int toWidth = this.reversed ? this.fromWidth : this.toWidth;
        int fromHeight = this.reversed ? this.toHeight : this.fromHeight;
        int toHeight = this.reversed ? this.fromHeight : this.toHeight;
        transformable.setSize((int)((float)fromWidth + (float)(toWidth - fromWidth) * comp), (int)((float)fromHeight + (float)(toHeight - fromHeight) * comp));
    }
}

