/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import com.google.common.collect.Maps;
import java.util.Map;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.component.ModelComponent;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.renderer.icon.provider.IconProviderBuilder;
import net.minecraft.tileentity.TileEntity;

public interface IModelIconProvider
extends IIconProvider {
    @Override
    default public void onComponentAdded(IComponentProvider provider) {
        ModelComponent mc = provider.getComponent(ModelComponent.class);
        if (mc != null) {
            mc.setIconProvider(this);
        }
    }

    @Override
    default public Icon getIcon() {
        return null;
    }

    public Icon getIcon(MalisisRenderer<? extends TileEntity> var1, String var2);

    public static class ModelIconProvider
    implements IModelIconProvider {
        private Icon icon;
        private Map<String, Icon> icons = Maps.newHashMap();

        public ModelIconProvider(IconProviderBuilder builder) {
            this.icon = builder.defaultIcon;
            this.icons = Maps.newHashMap(builder.shapeIcons);
        }

        @Override
        public Icon getIcon(MalisisRenderer<? extends TileEntity> renderer, String shapeName) {
            return this.icons.getOrDefault(shapeName, this.icon);
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }
    }
}

