/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.raytrace;

import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.Point;
import net.malisis.core.util.Ray;
import net.malisis.core.util.Vector;
import net.malisis.core.util.raytrace.Raytrace;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RaytraceBlock
extends Raytrace {
    private World world;
    private BlockPos pos;
    private IBlockState state;

    public RaytraceBlock(World world, Ray ray, BlockPos pos) {
        super(ray);
        this.world = world;
        this.pos = pos;
        this.state = world.func_180495_p(pos);
    }

    public RaytraceBlock(World world, Point src, Vector v, BlockPos pos) {
        this(world, new Ray(src, v), pos);
    }

    public RaytraceBlock(World world, Point src, Point dest, BlockPos pos) {
        this(world, new Ray(src, new Vector(src, dest)), pos);
        this.dest = dest;
    }

    public RaytraceBlock(World world, Vec3d src, Vec3d dest, BlockPos pos) {
        this(world, new Ray(src, dest), pos);
        this.dest = new Point(dest);
    }

    public RayTraceResult trace() {
        if (!(this.state.func_177230_c() instanceof IBoundingBox)) {
            return this.state.func_185910_a(this.world, this.pos, this.ray.origin.toVec3d(), this.dest.toVec3d());
        }
        IBoundingBox block = (IBoundingBox)this.state.func_177230_c();
        AxisAlignedBB[] aabbs = block.getRayTraceBoundingBox((IBlockAccess)this.world, this.pos, this.world.func_180495_p(this.pos));
        Pair<EnumFacing, Point> closest = super.trace(AABBUtils.offset(this.pos, aabbs));
        if (closest == null) {
            return null;
        }
        return new RayTraceResult(((Point)closest.getRight()).toVec3d(), (EnumFacing)closest.getLeft(), this.pos);
    }
}

