/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import com.enderio.core.common.event.ItemGUIRenderEvent;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EnderCoreMethods {
    @Nonnull
    public static ItemStack transferStackInSlot(@Nonnull ContainerFurnace inv, @Nonnull EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)inv.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 2) {
                if (!EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 1 && index != 0 ? (!TileEntityFurnace.func_145954_b((ItemStack)itemstack1) || !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 1, 2, false)) && (!FurnaceRecipes.func_77602_a().func_151395_a(itemstack1).func_190926_b() ? !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 0, 1, false) : (TileEntityFurnace.func_145954_b((ItemStack)itemstack1) ? !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 1, 2, false) : (index >= 3 && index < 30 ? !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 30, 39, false) : index >= 30 && index < 39 && !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 3, 30, false)))) : !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    private static boolean mergeItemStack(@Nonnull Container inv, @Nonnull ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)inv.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != itemstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack))) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)inv.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot1.func_75219_a()) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof com.enderio.core.common.interfaces.IOverlayRenderAware) {
                ((com.enderio.core.common.interfaces.IOverlayRenderAware)stack.func_77973_b()).renderItemOverlayIntoGUI(stack, xPosition, yPosition);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ItemGUIRenderEvent.Post(stack, xPosition, yPosition));
        }
    }

    public static void renderItemAndEffectIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof com.enderio.core.common.interfaces.IUnderlayRenderAware) {
                ((com.enderio.core.common.interfaces.IUnderlayRenderAware)stack.func_77973_b()).renderItemAndEffectIntoGUI(stack, xPosition, yPosition);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ItemGUIRenderEvent.Pre(stack, xPosition, yPosition));
        }
    }

    public static boolean isElytraFlying(@Nonnull EntityLivingBase entity) {
        ItemStack itemstack = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (itemstack.func_77973_b() instanceof com.enderio.core.common.interfaces.IElytraFlyingProvider) {
            return ((com.enderio.core.common.interfaces.IElytraFlyingProvider)itemstack.func_77973_b()).isElytraFlying(entity, itemstack, entity.field_70122_E || entity.func_184218_aH() || entity.func_70090_H() || EnderCoreMethods.isInLavaSafe((Entity)entity));
        }
        return false;
    }

    public static boolean isInLavaSafe(@Nonnull Entity entity) {
        return EnderCoreMethods.isMaterialInBBSafe(entity.field_70170_p, entity.func_174813_aQ().func_72321_a((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151587_i);
    }

    public static boolean isMaterialInBBSafe(@Nonnull World world, @Nonnull AxisAlignedBB bb, @Nonnull Material materialIn) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                    if (!world.func_175668_a((BlockPos)blockpos$pooledmutableblockpos, false) || world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_185904_a() != materialIn) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    public static boolean isCreeperTarget(@Nonnull EntityCreeper swellingCreeper, @Nonnull EntityLivingBase entitylivingbase) {
        if (entitylivingbase instanceof com.enderio.core.common.interfaces.ICreeperTarget) {
            return ((com.enderio.core.common.interfaces.ICreeperTarget)entitylivingbase).isCreeperTarget(swellingCreeper);
        }
        return true;
    }

    @Deprecated
    public static interface IUnderlayRenderAware
    extends com.enderio.core.common.interfaces.IUnderlayRenderAware {
    }

    @Deprecated
    public static interface IOverlayRenderAware
    extends com.enderio.core.common.interfaces.IOverlayRenderAware {
    }

    @Deprecated
    public static interface IElytraFlyingProvider
    extends com.enderio.core.common.interfaces.IElytraFlyingProvider {
    }

    @Deprecated
    public static interface ICreeperTarget
    extends com.enderio.core.common.interfaces.ICreeperTarget {
    }
}

