/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui_old.lib;

import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.ModuleManager;
import java.util.LinkedList;
import java.util.List;

public class ModuleBuilder {

    public static class RawColumns {
        private final int xPos;
        private final int yPos;
        private final int columns;
        public int builderEndY;
        private int elementHeight;
        private int elementSpacing;
        private int index = 0;
        private int lastLevelY = 0;
        private LinkedList<MGuiElementBase> elements = new LinkedList();

        public RawColumns(int xPos, int yPos, int columns, int elementHeight, int elementSpacing) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.columns = columns;
            this.builderEndY = yPos;
            this.elementHeight = elementHeight;
            this.elementSpacing = elementSpacing;
        }

        public void add(MGuiElementBase element) {
            int column = this.index % this.columns;
            int row = this.index / this.columns;
            int columnPos = this.xPos;
            if (column > 0) {
                columnPos = this.elements.getLast().xPos + this.elements.getLast().xSize;
            }
            element.moveBy(columnPos + this.elementSpacing - element.xPos, this.yPos + row * this.elementHeight + row * this.elementSpacing - element.yPos);
            this.builderEndY = element.yPos + this.elementHeight;
            this.elements.add(element);
            ++this.index;
        }

        public List<MGuiElementBase> finish() {
            return this.elements;
        }

        public void finish(ModuleManager manager, int level) {
            for (MGuiElementBase elementBase : this.elements) {
                manager.add(elementBase, level);
            }
        }
    }

    public static class EqualColumns {
        private final int xPos;
        private final int yPos;
        private final int columns;
        private final int elementWidth;
        private final int elementHeight;
        public int builderEndY;
        private int elementSpacing;
        private int index = 0;
        private LinkedList<MGuiElementBase> elements = new LinkedList();

        public EqualColumns(int xPos, int yPos, int columns, int elementWidth, int elementHeight, int elementSpacing) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.columns = columns;
            this.elementWidth = elementWidth;
            this.elementHeight = elementHeight;
            this.builderEndY = yPos;
            this.elementSpacing = elementSpacing;
        }

        public void add(MGuiElementBase element) {
            int column = this.index % this.columns;
            int row = this.index / this.columns;
            element.xSize = this.elementWidth;
            element.ySize = this.elementHeight;
            element.xPos = this.xPos + column * this.elementWidth + column * this.elementSpacing;
            element.yPos = this.yPos + row * this.elementHeight + row * this.elementSpacing;
            this.builderEndY = element.yPos + element.ySize;
            this.elements.add(element);
            ++this.index;
        }

        public List<MGuiElementBase> finish() {
            return this.elements;
        }

        public void finish(ModuleManager manager, int level) {
            for (MGuiElementBase elementBase : this.elements) {
                manager.add(elementBase, level);
            }
        }
    }
}

