/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import openmods.renderer.ITileEntityModel;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.BlockUtils;
import org.lwjgl.opengl.GL11;

public class SimpleModelTileEntityRenderer<T extends OpenTileEntity>
extends TileEntitySpecialRenderer<T> {
    private final ITileEntityModel<T> model;
    private final ResourceLocation texture;

    public SimpleModelTileEntityRenderer(ITileEntityModel<T> model, ResourceLocation texture) {
        this.model = model;
        this.texture = texture;
    }

    public void render(T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (te != null) {
            GL11.glRotatef((float)(-BlockUtils.getRotationFromOrientation(((OpenTileEntity)te).getOrientation())), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.func_147499_a(this.texture);
        this.model.render(te, partialTicks);
        GL11.glPopMatrix();
    }

    public static <T extends OpenTileEntity> TileEntitySpecialRenderer<T> create(ITileEntityModel<T> model, ResourceLocation texture) {
        return new SimpleModelTileEntityRenderer<T>(model, texture);
    }
}

