/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.latmod.yabba.api.BarrelContentType;
import com.latmod.yabba.api.UpgradeData;
import com.latmod.yabba.block.BlockBarrel;
import com.latmod.yabba.net.MessageUpdateBarrelContent;
import com.latmod.yabba.tile.Barrel;
import com.latmod.yabba.tile.BarrelNetwork;
import com.latmod.yabba.tile.IBarrelBlock;
import com.latmod.yabba.util.BarrelLook;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileBarrel
extends TileBase
implements IBarrelBlock,
ITickable {
    public final Barrel barrel = new Barrel(this, this.getContentType());
    public long lastClick;
    private float cachedRotationY;
    private AxisAlignedBB cachedAABB;
    private int updateLevel = 0;
    private int redstoneOut = -1;

    public TileBarrel() {
        this.func_145836_u();
    }

    public BarrelContentType getContentType() {
        return BarrelContentType.DECORATIVE;
    }

    @Override
    public final TileEntity getBarrelTileEntity() {
        return this;
    }

    @Override
    public final void clearCache() {
        this.func_145836_u();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.barrel.clearCache();
        this.cachedRotationY = -1.0f;
        this.cachedAABB = null;
    }

    @Override
    public final Barrel getBarrel() {
        return this.barrel;
    }

    @Override
    public void markBarrelDirty(boolean majorChange) {
        this.clearCache();
        this.updateLevel = Math.max(this.updateLevel, majorChange ? 2 : 1);
    }

    public void onUpdatePacket(EnumSaveType type) {
        this.markBarrelDirty(true);
    }

    public void func_145843_s() {
        if (this.func_145830_o()) {
            BarrelNetwork.get(this.func_145831_w()).barrelUpdated(this.getContentType());
        }
        super.func_145843_s();
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.func_145830_o()) {
            BarrelNetwork.get(this.func_145831_w()).barrelUpdated(this.getContentType());
        }
    }

    public void func_70296_d() {
        this.markBarrelDirty(false);
    }

    @Override
    public final boolean isBarrelInvalid() {
        return this.func_145837_r();
    }

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        this.barrel.writeData(nbt);
        if (this.redstoneOut >= 0) {
            nbt.func_74768_a("RedstoneOut", this.redstoneOut);
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.func_145836_u();
        this.barrel.readData(nbt);
        this.redstoneOut = nbt.func_74764_b("RedstoneOut") ? nbt.func_74762_e("RedstoneOut") : -1;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.barrel.content.hasCapability(capability, facing) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T t = this.barrel.content.getCapability(capability, facing);
        return (T)(t == null ? super.getCapability(capability, facing) : t);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.barrel.content.update();
            for (int i = 0; i < this.barrel.getUpgradeCount(); ++i) {
                UpgradeData data = this.barrel.getUpgrade(i);
                if (data == null || !data.isTicking(this.field_145850_b)) continue;
                data.onTick(this.barrel);
            }
        }
        if (this.updateLevel > 0) {
            if (!this.field_145850_b.field_72995_K) {
                new MessageUpdateBarrelContent(this).sendToAllTracking(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            }
            if (this.updateLevel >= 2) {
                this.sendDirtyUpdate();
            }
            this.updateLevel = 0;
        }
        int prev = this.redstoneOut;
        this.redstoneOut = this.barrel.content.redstoneOutput();
        if (prev != this.redstoneOut) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public float getRotationAngleY() {
        if (this.cachedRotationY == -1.0f) {
            IBlockState state = this.getBlockState();
            if (!(state.func_177230_c() instanceof BlockBarrel)) {
                return 0.0f;
            }
            this.cachedRotationY = ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_185119_l() + 180.0f;
        }
        return this.cachedRotationY;
    }

    public AxisAlignedBB getAABB() {
        if (this.cachedAABB == null) {
            this.cachedAABB = this.barrel.getLook().model.getAABB(this.getBarrelRotation());
        }
        return this.cachedAABB;
    }

    public void writeToPickBlock(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        BarrelLook look = this.barrel.getLook();
        if (!look.model.isDefault()) {
            nbt.func_74778_a("Model", look.model.getNBTName());
        }
        if (!look.skin.isEmpty()) {
            nbt.func_74778_a("Skin", look.skin);
        }
        if (!nbt.func_82582_d()) {
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbt);
        }
    }

    @Override
    public EnumFacing getBarrelRotation() {
        return (EnumFacing)this.getBlockState().func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }
}

