/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stoneblockutilities.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import ftblag.stoneblockutilities.gson.SBUGson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.fml.common.LoaderException;

public class SBUGsonParser {
    public static SBUGson.Cfg cfg;
    private static Gson gson;

    public static void parseFile(File file) {
        if (!file.exists()) {
            try {
                SBUGsonParser.createDefault(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            cfg = (SBUGson.Cfg)gson.fromJson((Reader)new BufferedReader(new FileReader(file)), SBUGson.Cfg.class);
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            throw new LoaderException("Failed to load cfg!", e);
        }
    }

    private static void createDefault(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        } else {
            file.delete();
            file.createNewFile();
        }
        SBUGson.Cfg cfg = new SBUGson.Cfg();
        cfg.active_render = true;
        cfg.handDrops = new ArrayList<SBUGson.HandDrops>(Arrays.asList(new SBUGson.HandDrops("minecraft:stone:0", "exnihilocreatio:item_pebble:0", 4, 2, 5, 3.5)));
        cfg.crookDrops = new ArrayList<SBUGson.CrookDrops>(Arrays.asList(new SBUGson.CrookDrops("minecraft:dirt:0", true, 1, Arrays.asList(new SBUGson.CrookDropGson("minecraft:sapling:0", 1), new SBUGson.CrookDropGson("minecraft:sapling:1", 1), new SBUGson.CrookDropGson("minecraft:sapling:2", 1), new SBUGson.CrookDropGson("minecraft:sapling:3", 1), new SBUGson.CrookDropGson("minecraft:sapling:4", 1), new SBUGson.CrookDropGson("minecraft:sapling:5", 1)))));
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(file));
            fw.write(gson.toJson((Object)cfg));
            fw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

