/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stoneblockutilities.gson;

import ftblag.stoneblockutilities.events.SBUEvents;
import ftblag.stoneblockutilities.gson.SBUGsonParser;
import ftblag.stoneblockutilities.registry.SBURegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.LoaderException;

public class SBUGsonUtils {
    public static HashMap<IBlockState, HandDrop> handDrops = new HashMap();
    public static HashMap<IBlockState, CrookDrop> crookDrops = new HashMap();

    public static void parse() {
        SBUGsonParser.cfg.handDrops.forEach(i -> {
            try {
                String[] block1 = i.block.split(":");
                Block block = Block.func_149684_b((String)(block1[0] + ":" + block1[1]));
                int blockMeta = Integer.parseInt(block1[2]);
                IBlockState state = block.func_176203_a(blockMeta);
                String[] drop1 = i.drop.split(":");
                String modidName = drop1[0] + ":" + drop1[1];
                Item drop = modidName.equals("exnihilocreatio:item_pebble") && !SBURegistry.isExNihiloLoaded ? Item.func_111206_d((String)"stoneblockutilities:stonepebble") : Item.func_111206_d((String)modidName);
                ItemStack drop_with = new ItemStack(drop, i.drop_with, Integer.parseInt(drop1[2]));
                ItemStack drop_without = new ItemStack(drop, i.drop_without, Integer.parseInt(drop1[2]));
                handDrops.put(state, new HandDrop(new ItemStack(block, 1, blockMeta), drop_with, drop_without, i.chance, i.speed));
            }
            catch (Exception e) {
                throw new LoaderException("Failed to parse cfg! May be wrong elements!", (Throwable)e);
            }
        });
        SBUGsonParser.cfg.crookDrops.forEach(i -> {
            try {
                String[] block1 = i.block.split(":");
                Block block = Block.func_149684_b((String)(block1[0] + ":" + block1[1]));
                int blockMeta = Integer.parseInt(block1[2]);
                IBlockState state = block.func_176203_a(blockMeta);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                i.drops.forEach(d -> {
                    String[] drop1 = d.drop.split(":");
                    Item drop = Item.func_111206_d((String)(drop1[0] + ":" + drop1[1]));
                    drops.add(new ItemStack(drop, d.drop_size, Integer.parseInt(drop1[2])));
                });
                crookDrops.put(state, new CrookDrop(new ItemStack(block, 1, blockMeta), i.randomDrop, i.randomDropAmount, drops));
            }
            catch (Exception e) {
                throw new LoaderException("Failed to parse cfg! May be wrong elements!", (Throwable)e);
            }
        });
    }

    public static void spawnItem(BlockEvent.BreakEvent e, ItemStack stack) {
        e.getWorld().func_72838_d((Entity)new EntityItem(e.getWorld(), (double)e.getPos().func_177958_n() + 0.5, (double)e.getPos().func_177956_o() + 0.5, (double)e.getPos().func_177952_p() + 0.5, stack));
    }

    public static void dropHand(BlockEvent.BreakEvent e) {
        if (handDrops.containsKey(e.getState())) {
            HandDrop drop = handDrops.get(e.getState());
            if (SBUEvents.rnd.nextInt(100) < drop.chance) {
                SBUGsonUtils.spawnItem(e, drop.dropWith.func_77946_l());
            } else {
                SBUGsonUtils.spawnItem(e, drop.dropWithout.func_77946_l());
            }
        }
    }

    public static void dropCrook(BlockEvent.BreakEvent e, EntityPlayer player) {
        if (crookDrops.containsKey(e.getState())) {
            CrookDrop drop = crookDrops.get(e.getState());
            if (drop.randomDrop) {
                for (int i = 0; i < drop.randomDropAmount; ++i) {
                    SBUGsonUtils.spawnItem(e, drop.drops.get(SBUEvents.rnd.nextInt(drop.drops.size())));
                }
            } else {
                for (ItemStack stack : drop.drops) {
                    SBUGsonUtils.spawnItem(e, stack.func_77946_l());
                }
            }
            e.getWorld().func_175698_g(e.getPos());
            player.func_184614_ca().func_77972_a(1, (EntityLivingBase)player);
        }
    }

    public static HandDrop getHandDropFromOriginal(ItemStack original) {
        for (HandDrop drop : handDrops.values()) {
            if (!ItemStack.func_179545_c((ItemStack)drop.original, (ItemStack)original)) continue;
            return drop;
        }
        return null;
    }

    public static CrookDrop getCrookDropFromOriginal(ItemStack original) {
        for (CrookDrop drop : crookDrops.values()) {
            if (!ItemStack.func_179545_c((ItemStack)drop.original, (ItemStack)original)) continue;
            return drop;
        }
        return null;
    }

    public static class CrookDrop {
        public ItemStack original;
        public boolean randomDrop;
        public int randomDropAmount;
        public List<ItemStack> drops;

        public CrookDrop(ItemStack original, boolean randomDrop, int randomDropAmount, List<ItemStack> drops) {
            this.original = original;
            this.randomDrop = randomDrop;
            this.randomDropAmount = randomDropAmount;
            this.drops = drops;
        }
    }

    public static class HandDrop {
        public ItemStack original;
        public ItemStack dropWith;
        public ItemStack dropWithout;
        public int chance;
        public double speed;

        public HandDrop(ItemStack original, ItemStack dropWith, ItemStack dropWithout, int chance, double speed) {
            this.original = original;
            this.dropWith = dropWith;
            this.dropWithout = dropWithout;
            this.chance = chance;
            this.speed = speed;
        }
    }
}

