/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stoneblockutilities.jei.hand;

import ftblag.stoneblockutilities.gson.SBUGsonUtils;
import ftblag.stoneblockutilities.jei.hand.HandRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class HandRecipeCategory
implements IRecipeCategory<HandRecipe> {
    public static final String UID = "stoneblockutilities:hand";
    private static final ResourceLocation texture = new ResourceLocation("stoneblockutilities", "textures/gui/jei_page.png");
    private final IDrawableStatic background;

    public HandRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 166, 128);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return "Hand";
    }

    public String getModName() {
        return "stoneblockutilities";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, HandRecipe recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 74, 9);
        ItemStack original = recipeWrapper.getInputs().get(0);
        recipeLayout.getItemStacks().set(0, original);
        final SBUGsonUtils.HandDrop drop = SBUGsonUtils.getHandDropFromOriginal(original);
        int slotIndex = 1;
        for (int i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
            int slotX = 2 + i % 9 * 18;
            int slotY = 36 + i / 9 * 18;
            ItemStack outputStack = recipeWrapper.getOutputs().get(i);
            recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
            recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
                if (!input) {
                    tooltip.add("Drop Chance");
                    if (slotIndex == 2) {
                        tooltip.add(" * " + drop.dropWithout.func_190916_E() + "x 100%");
                    } else {
                        tooltip.add(" * " + drop.dropWith.func_190916_E() + "x " + 100 / drop.chance + "%");
                    }
                }
            }
        });
    }
}

