/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.fx;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.psi.client.fx.FXQueued;
import vazkii.psi.client.fx.ParticleRenderDispatcher;

public class FXSparkle
extends FXQueued {
    public static final ResourceLocation particles = new ResourceLocation("psi:textures/misc/particles.png");
    public static final Queue<FXSparkle> queuedRenders = new ArrayDeque<FXSparkle>();
    public final boolean shrink = true;
    public final int particle = 16;
    public final int multiplier;

    public FXSparkle(World world, double x, double y, double z, float size, float red, float green, float blue, int m) {
        super(world, x, y, z, size, red, green, blue, m * 3);
        this.multiplier = m;
    }

    @Override
    public void setSpeed(double x, double y, double z) {
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
    }

    public static void dispatchQueuedRenders(Tessellator tessellator) {
        ParticleRenderDispatcher.sparkleFxCount = 0;
        FXQueued.dispatchQueuedRenders(tessellator, particles, queuedRenders);
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    @Override
    protected float getScale() {
        float rotation = 0.1f * this.field_70544_f;
        return rotation *= ((float)(this.field_70547_e - this.field_70546_d) + 1.0f) / (float)this.field_70547_e;
    }

    @Override
    protected float getMinU() {
        int part = 16 + this.field_70546_d / this.multiplier;
        return (float)(part % 8) / 8.0f;
    }

    @Override
    protected float getMaxU() {
        return this.getMinU() + 0.125f;
    }

    @Override
    protected float getMinV() {
        int part = 16 + this.field_70546_d / this.multiplier;
        return (float)(part >> 3) / 8.0f;
    }

    @Override
    protected float getMaxV() {
        return this.getMinV() + 0.125f;
    }

    @Override
    protected void addToQueue() {
        queuedRenders.add(this);
    }

    @Override
    protected void incrementQueueCount() {
        ++ParticleRenderDispatcher.sparkleFxCount;
    }

    @Override
    protected boolean hasSlowdown() {
        return true;
    }

    @Override
    protected boolean hasFriction() {
        return true;
    }
}

