/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.jei.tricks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.recipe.TrickRecipe;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.jei.JEICompat;

public class TrickCraftingRecipeJEI
implements IRecipeWrapper {
    private static final IDrawable programmerHover = JEICompat.helpers.getGuiHelper().createDrawable(new ResourceLocation("psi", "textures/gui/programmer.png"), 16, 184, 16, 16);
    private static final int trickX = 43;
    private static final int trickY = 24;
    @Nullable
    private final IDrawable icon;
    private final SpellPiece piece;
    private final TrickRecipe recipe;

    public TrickCraftingRecipeJEI(TrickRecipe recipe) {
        this.recipe = recipe;
        ResourceLocation location = PsiAPI.simpleSpellTextures.get(recipe.getPiece());
        Class pieceType = (Class)PsiAPI.spellPieceRegistry.func_82594_a((Object)recipe.getPiece());
        this.icon = location != null ? JEICompat.helpers.getGuiHelper().createDrawable(location, 0, 0, 256, 256) : null;
        this.piece = pieceType != null ? SpellPiece.create(pieceType, new Spell()) : null;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, (List)Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])this.recipe.getInput().func_193365_a()), Lists.newArrayList((Object[])new ItemStack[]{this.recipe.getCAD()})}));
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getOutput());
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.icon != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0625f);
            this.icon.draw(minecraft, 688, 384);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            if (this.onTrick(mouseX, mouseY)) {
                programmerHover.draw(minecraft, 43, 24);
            }
        }
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (this.onTrick(mouseX, mouseY) && this.piece != null) {
            this.piece.getTooltip(tooltip);
            return tooltip;
        }
        return tooltip;
    }

    public boolean onTrick(int mouseX, int mouseY) {
        return mouseX >= 43 && mouseX <= 59 && mouseY >= 24 && mouseY <= 40;
    }
}

