/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.entity.Entity;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class PieceTrickEidosAnchor
extends PieceTrick {
    SpellParam time;

    public PieceTrickEidosAnchor(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.RED, false, true);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double timeVal = (Double)this.getParamEvaluation(this.time);
        if (timeVal == null || timeVal <= 0.0 || timeVal != (double)timeVal.intValue()) {
            throw new SpellCompilationException("psi.spellerror.nonpositiveinteger", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(timeVal * 5.5 + 20.0));
        meta.addStat(EnumSpellStat.COST, timeVal.intValue() * 40);
    }

    @Override
    public Object execute(SpellContext context) {
        Double timeVal = (Double)this.getParamValue(context, this.time);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(context.caster);
        data.eidosAnchor = Vector3.fromEntity((Entity)context.caster);
        data.eidosAnchorPitch = context.caster.field_70125_A;
        data.eidosAnchorYaw = context.caster.field_70177_z;
        data.eidosAnchorTime = timeVal.intValue() * 20;
        data.postAnchorRecallTime = 0;
        data.isAnchored = true;
        return null;
    }
}

