/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.tile;

import com.latmod.mods.projectex.net.MessageSyncEMC;
import com.latmod.mods.projectex.net.ProjectEXNetHandler;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.utils.NBTWhitelist;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileLink
extends TileEntity
implements IItemHandlerModifiable,
ITickable {
    public UUID owner = null;
    public String name = "";
    public ItemStack output = ItemStack.field_190927_a;
    private boolean isDirty = false;
    public final ItemStack[] inputSlots = new ItemStack[18];

    public TileLink() {
        Arrays.fill(this.inputSlots, ItemStack.field_190927_a);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.owner = nbt.func_186857_a("owner");
        this.name = nbt.func_74779_i("name");
        this.output = new ItemStack(nbt.func_74775_l("output"));
        if (this.output.func_190926_b()) {
            this.output = ItemStack.field_190927_a;
        }
        NBTTagList inputList = nbt.func_150295_c("input", 10);
        Arrays.fill(this.inputSlots, ItemStack.field_190927_a);
        for (int i = 0; i < inputList.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = inputList.func_150305_b(i);
            this.inputSlots[nbt1.func_74771_c((String)"Slot")] = new ItemStack(nbt1);
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_186854_a("owner", this.owner);
        nbt.func_74778_a("name", this.name);
        this.output.func_190920_e(1);
        if (!this.output.func_190926_b()) {
            nbt.func_74782_a("output", (NBTBase)this.output.serializeNBT());
        }
        NBTTagList inputList = new NBTTagList();
        for (int i = 0; i < this.inputSlots.length; ++i) {
            if (this.inputSlots[i].func_190926_b()) continue;
            NBTTagCompound nbt1 = this.inputSlots[i].serializeNBT();
            nbt1.func_74774_a("Slot", (byte)i);
            inputList.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("input", (NBTBase)inputList);
        return super.func_189515_b(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.serializeNBT();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, side));
    }

    public int getSlots() {
        return 19;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 18) {
            if (this.field_145850_b.field_72995_K || this.output.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            this.output.func_190920_e(1);
            long value = ProjectEAPI.getEMCProxy().getValue(this.output);
            if (value > 0L) {
                IKnowledgeProvider knowledgeProvider = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(this.owner);
                if (knowledgeProvider.getEmc() < (double)value) {
                    return ItemStack.field_190927_a;
                }
                this.output.func_190920_e(this.getCount(knowledgeProvider, value, Integer.MAX_VALUE));
                return this.output.func_190916_E() <= 0 ? ItemStack.field_190927_a : this.output;
            }
            return ItemStack.field_190927_a;
        }
        return this.inputSlots[slot];
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot != 18) {
            this.inputSlots[slot] = stack;
            this.func_70296_d();
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (slot == 18 || !ProjectEAPI.getEMCProxy().hasValue(stack)) {
            return stack;
        }
        int limit = stack.func_77976_d();
        if (!this.inputSlots[slot].func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.inputSlots[slot])) {
                return stack;
            }
            limit -= this.inputSlots[slot].func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (this.inputSlots[slot].func_190926_b()) {
                this.inputSlots[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                this.inputSlots[slot].func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.func_70296_d();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot != 18 && ProjectEAPI.getEMCProxy().hasValue(stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 18 && amount > 0 && !this.field_145850_b.field_72995_K && !this.output.func_190926_b()) {
            this.output.func_190920_e(1);
            long value = ProjectEAPI.getEMCProxy().getValue(this.output);
            if (value > 0L) {
                IKnowledgeProvider knowledgeProvider = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(this.owner);
                if (knowledgeProvider.getEmc() < (double)value) {
                    return ItemStack.field_190927_a;
                }
                ItemStack stack = this.output.func_77946_l();
                stack.func_190920_e(this.getCount(knowledgeProvider, value, Math.min(amount, this.output.func_77976_d())));
                if (stack.func_190916_E() >= 1) {
                    if (stack.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT((ItemStack)stack)) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    if (!simulate) {
                        knowledgeProvider.setEmc(knowledgeProvider.getEmc() - (double)(value * (long)stack.func_190916_E()));
                        EntityPlayerMP player = this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.owner);
                        if (player != null) {
                            ProjectEXNetHandler.NET.sendTo((IMessage)new MessageSyncEMC(knowledgeProvider.getEmc()), player);
                        }
                    }
                    return stack;
                }
                return ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            EntityPlayerMP player;
            boolean sync = false;
            IKnowledgeProvider knowledgeProvider = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(this.owner);
            for (int i = 0; i < this.inputSlots.length; ++i) {
                long value;
                if (this.inputSlots[i].func_190926_b() || (value = ProjectEAPI.getEMCProxy().getValue(this.inputSlots[i])) <= 0L) continue;
                knowledgeProvider.setEmc(knowledgeProvider.getEmc() + (double)((long)((double)this.inputSlots[i].func_190916_E() * (double)value * ProjectEConfig.difficulty.covalenceLoss)));
                sync = true;
                this.inputSlots[i] = ItemStack.field_190927_a;
                this.func_70296_d();
            }
            if (sync && (player = this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.owner)) != null) {
                ProjectEXNetHandler.NET.sendTo((IMessage)new MessageSyncEMC(knowledgeProvider.getEmc()), player);
            }
        }
        if (this.isDirty) {
            this.isDirty = false;
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public int getCount(IKnowledgeProvider knowledgeProvider, long value, int limit) {
        if (knowledgeProvider.getEmc() < (double)value) {
            return 0;
        }
        return (int)Math.min((double)limit, knowledgeProvider.getEmc() / (double)value);
    }
}

