/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.EntityTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import romelo333.notenoughwands.ConfigSetup;

public class BlackListSettings {
    protected static Map<String, Double> blacklistedBlocks = new HashMap<String, Double>();
    protected static Map<String, Double> blackListedMobs = new HashMap<String, Double>();

    public static double getBlacklistCost(Block block) {
        double cost = 1.0;
        ResourceLocation registryName = block.getRegistryName();
        if (blacklistedBlocks.containsKey(registryName.func_110624_b() + ":*")) {
            cost = blacklistedBlocks.get(registryName.func_110624_b() + ":*");
        } else {
            String regName = registryName.toString();
            if (blacklistedBlocks.containsKey(regName)) {
                cost = blacklistedBlocks.get(regName);
            }
        }
        return cost;
    }

    private static void blackListBlock(Configuration cfg, String name) {
        BlackListSettings.setCostBlock(cfg, name, -1.0);
    }

    private static void setCostBlock(Configuration cfg, String name, double cost) {
        cfg.get(ConfigSetup.CATEGORY_MOVINGBLACKLIST, name, cost);
        blacklistedBlocks.put(name, cost);
    }

    public static double getBlacklistEntity(Entity entity) {
        double cost = 1.0;
        String name = EntityTools.findEntityIdByClass(entity.getClass());
        if (blackListedMobs.containsKey(name)) {
            cost = blackListedMobs.get(name);
        }
        return cost;
    }

    private static void blackListEntity(Configuration cfg, String name) {
        BlackListSettings.setCostEntity(cfg, name, -1.0);
    }

    private static void setCostEntity(Configuration cfg, String name, double cost) {
        if (name != null && !name.isEmpty()) {
            cfg.get(ConfigSetup.CATEGORY_CAPTUREBLACKLIST, name, cost);
            blackListedMobs.put(name, cost);
        }
    }

    public static void setupMovingWandBlacklist(Configuration cfg) {
        ConfigCategory category = cfg.getCategory(ConfigSetup.CATEGORY_MOVINGBLACKLIST);
        if (category.isEmpty()) {
            BlackListSettings.blackListBlock(cfg, "rftools:shield_block1");
            BlackListSettings.blackListBlock(cfg, "rftools:shield_block2");
            BlackListSettings.blackListBlock(cfg, "rftools:shield_block3");
            BlackListSettings.blackListBlock(cfg, "rftools:shield_block4");
            BlackListSettings.blackListBlock(cfg, "rftools:notick_invisible_shield_block");
            BlackListSettings.blackListBlock(cfg, "rftools:invisible_shield_block");
            BlackListSettings.blackListBlock(cfg, "rftools:notick_shield_block");
            BlackListSettings.blackListBlock(cfg, "rftools:shield_block");
            BlackListSettings.blackListBlock(cfg, "refinedstorage:*");
            BlackListSettings.blackListBlock(cfg, Blocks.field_150357_h.getRegistryName().toString());
            BlackListSettings.blackListBlock(cfg, Blocks.field_150427_aO.getRegistryName().toString());
            BlackListSettings.blackListBlock(cfg, Blocks.field_150384_bq.getRegistryName().toString());
            BlackListSettings.setCostBlock(cfg, Blocks.field_150474_ac.getRegistryName().toString(), 5.0);
        } else {
            for (Map.Entry entry : category.entrySet()) {
                blacklistedBlocks.put((String)entry.getKey(), ((Property)entry.getValue()).getDouble());
            }
        }
    }

    public static void setupCapturingWandBlacklist(Configuration cfg) {
        ConfigCategory category = cfg.getCategory(ConfigSetup.CATEGORY_CAPTUREBLACKLIST);
        if (category.isEmpty()) {
            BlackListSettings.blackListEntity(cfg, EntityTools.findEntityIdByClass(EntityDragon.class));
            BlackListSettings.setCostEntity(cfg, EntityTools.findEntityIdByClass(EntityWither.class), 2.0);
        } else {
            for (Map.Entry entry : category.entrySet()) {
                blackListedMobs.put((String)entry.getKey(), ((Property)entry.getValue()).getDouble());
            }
        }
    }
}

