/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import romelo333.notenoughwands.ConfigSetup;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.ModSounds;
import romelo333.notenoughwands.varia.Tools;

public class TeleportationWand
extends GenericWand {
    private float teleportVolume = 1.0f;
    private int maxdist = 30;
    private boolean teleportThroughWalls = true;

    public TeleportationWand() {
        this.setup("teleportation_wand").xpUsage(4).loot(6);
    }

    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag b) {
        super.func_77624_a(stack, player, list, b);
        list.add("Right click to teleport forward");
        list.add("until a block is hit or maximum");
        list.add("distance is reached.");
        if (this.teleportThroughWalls) {
            list.add("Sneak to teleport through walls");
        } else {
            list.add("Sneak for half distance");
        }
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 500, 100000, 200, 200000, 100, 500000);
        this.teleportVolume = (float)cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_volume", (double)this.teleportVolume, "Volume of the teleportation sound (set to 0 to disable)").getDouble();
        this.maxdist = cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxdist", this.maxdist, "Maximum teleportation distance").getInt();
        this.teleportThroughWalls = cfg.getBoolean(this.getConfigPrefix() + "_teleportThroughWalls", ConfigSetup.CATEGORY_WANDS, this.teleportThroughWalls, "If set to true then sneak-right click will teleport through walls. Otherwise sneak-right click will teleport half distance");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockPos blockPos;
            RayTraceResult position;
            if (!this.checkUsage(stack, player, 1.0f)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            Vec3d lookVec = player.func_70040_Z();
            Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            int distance = this.maxdist;
            boolean gothrough = false;
            if (player.func_70093_af()) {
                if (this.teleportThroughWalls) {
                    gothrough = true;
                }
                distance /= 2;
            }
            Vec3d end = start.func_72441_c(lookVec.field_72450_a * (double)distance, lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance);
            RayTraceResult rayTraceResult = position = gothrough ? null : world.func_72933_a(start, end);
            if (position == null) {
                if (!(!gothrough || world.func_175623_d(blockPos = new BlockPos(end.field_72450_a, end.field_72448_b, end.field_72449_c)) && world.func_175623_d(blockPos.func_177984_a()))) {
                    Tools.error(player, "You will suffocate if you teleport there!");
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
                }
                player.func_70634_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            } else {
                blockPos = position.func_178782_a();
                int x = blockPos.func_177958_n();
                int y = blockPos.func_177956_o();
                int z = blockPos.func_177952_p();
                if (world.func_175623_d(blockPos.func_177984_a()) && world.func_175623_d(blockPos.func_177981_b(2))) {
                    player.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                } else {
                    switch (position.field_178784_b) {
                        case DOWN: {
                            player.func_70634_a((double)x + 0.5, (double)(y - 2), (double)z + 0.5);
                            break;
                        }
                        case UP: {
                            Tools.error(player, "You will suffocate if you teleport there!");
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
                        }
                        case NORTH: {
                            player.func_70634_a((double)x + 0.5, (double)y, (double)(z - 1) + 0.5);
                            break;
                        }
                        case SOUTH: {
                            player.func_70634_a((double)x + 0.5, (double)y, (double)(z + 1) + 0.5);
                            break;
                        }
                        case WEST: {
                            player.func_70634_a((double)(x - 1) + 0.5, (double)y, (double)z + 0.5);
                            break;
                        }
                        case EAST: {
                            player.func_70634_a((double)(x + 1) + 0.5, (double)y, (double)z + 0.5);
                        }
                    }
                }
            }
            this.registerUsage(stack, player, 1.0f);
            if ((double)this.teleportVolume >= 0.01) {
                SoundEvent teleport = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("notenoughwands", "teleport"));
                ModSounds.playSound(player.func_130014_f_(), teleport, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.teleportVolume, 1.0);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }
}

