/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.asm;

import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import java.util.HashMap;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class Lighting {
    public static final WeakHashMap<World, HashMap<EnumSkyBlock, Set<ILight>>> plusLights = new WeakHashMap();
    public static final WeakHashMap<World, HashMap<EnumSkyBlock, Set<ILight>>> negLights = new WeakHashMap();
    private static final EnumSkyBlock[] removeTypes = new EnumSkyBlock[]{null, EnumSkyBlock.BLOCK, EnumSkyBlock.SKY};

    public static void register(ILight light, WeakHashMap<World, HashMap<EnumSkyBlock, Set<ILight>>> lightType) {
        HashMap enumMap = lightType.computeIfAbsent(light.getLightWorld(), k -> new HashMap());
        for (EnumSkyBlock type : light.getLightType()) {
            WeakLinkedSet<ILight> lightMap = (WeakLinkedSet<ILight>)enumMap.get(type);
            if (lightMap == null) {
                lightMap = new WeakLinkedSet<ILight>();
                enumMap.put(type, lightMap);
            }
            lightMap.add(light);
        }
        WeakLinkedSet<ILight> lightMap = (WeakLinkedSet<ILight>)enumMap.get(null);
        if (lightMap == null) {
            lightMap = new WeakLinkedSet<ILight>();
            enumMap.put(null, lightMap);
        }
        lightMap.add(light);
    }

    public static void unregister(ILight light, WeakHashMap<World, HashMap<EnumSkyBlock, Set<ILight>>> lightType) {
        HashMap<EnumSkyBlock, Set<ILight>> map = lightType.get(light.getLightWorld());
        if (map == null) {
            return;
        }
        for (EnumSkyBlock type : removeTypes) {
            Set<ILight> lightMap = map.get(type);
            if (lightMap == null) continue;
            lightMap.remove(light);
            if (!lightMap.isEmpty()) continue;
            map.remove(type);
            if (!map.isEmpty()) continue;
            lightType.remove(light.getLightWorld());
        }
    }

    public static Set<ILight> getLightList(World world, BlockPos pos, EnumSkyBlock type, WeakHashMap<World, HashMap<EnumSkyBlock, Set<ILight>>> lightType) {
        HashMap<EnumSkyBlock, Set<ILight>> enumMap = lightType.get(world);
        if (enumMap == null) {
            return null;
        }
        Set<ILight> worldMap = enumMap.get(type);
        if (worldMap == null) {
            return null;
        }
        if (worldMap.isEmpty()) {
            enumMap.remove(type);
            if (enumMap.isEmpty()) {
                lightType.remove(world);
            }
            return null;
        }
        return worldMap;
    }

    public static int getLightFor(World world, EnumSkyBlock type, BlockPos pos, int curLevel) {
        if (plusLights.isEmpty() && negLights.isEmpty()) {
            return curLevel;
        }
        Set<ILight> negLightList = Lighting.getLightList(world, pos, type, negLights);
        Set<ILight> plusLightList = Lighting.getLightList(world, pos, type, plusLights);
        if (negLightList == null) {
            if (plusLightList == null) {
                return curLevel;
            }
            float level = curLevel;
            for (ILight iLight : plusLightList) {
                if (!((level += iLight.getLightOffset(pos, type)) > 15.0f)) continue;
                return 15;
            }
            return Math.min((int)level, 15);
        }
        float level = curLevel;
        if (plusLightList != null) {
            for (ILight iLight : plusLightList) {
                if ((level += iLight.getLightOffset(pos, type)) > 15.0f) break;
            }
        }
        if (level > 15.0f) {
            level = 15.0f;
        }
        for (ILight iLight : negLightList) {
            if (!((level += iLight.getLightOffset(pos, type)) < 0.0f)) continue;
            return 0;
        }
        return Math.max(0, (int)level);
    }

    public static int getCombinedLight(World world, BlockPos pos, int curLevel) {
        if (plusLights.isEmpty() && negLights.isEmpty()) {
            return curLevel;
        }
        Set<ILight> plusLights = Lighting.getLightList(world, pos, null, Lighting.plusLights);
        Set<ILight> negLights = Lighting.getLightList(world, pos, null, Lighting.negLights);
        if (negLights == null) {
            if (curLevel == 15) {
                return 15;
            }
            float level = curLevel;
            if (plusLights != null) {
                for (ILight iLight : plusLights) {
                    if (!((level += iLight.getLightOffset(pos, null)) >= 15.0f)) continue;
                    return 15;
                }
            }
            return (int)level;
        }
        float level = curLevel;
        if (plusLights != null) {
            for (ILight iLight : plusLights) {
                if ((level += iLight.getLightOffset(pos, null)) >= 15.0f) break;
            }
        }
        if (level > 15.0f) {
            level = 15.0f;
        }
        for (ILight iLight : negLights) {
            if (!((level += iLight.getLightOffset(pos, null)) <= 0.0f)) continue;
            return 0;
        }
        return (int)level;
    }
}

