/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.textures.ConnectedTexturesHelper;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import com.rwtema.extrautils2.textures.SpriteConnectedTextures;
import com.rwtema.extrautils2.textures.TextureComponent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ConnectedTexture
implements ISolidWorldTexture {
    public static EnumFacing[] up = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.NORTH, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP};
    public static EnumFacing[] left = new EnumFacing[]{EnumFacing.WEST, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH};
    public final String baseTextureName;
    final XUBlock base;
    final IBlockState state;
    public String texture;
    public SpriteConnectedTextures[] icons = new SpriteConnectedTextures[47];
    boolean hasConnectedTextures = false;

    public ConnectedTexture(String texture, IBlockState state, XUBlockConnectedTextureBase base) {
        this.texture = texture;
        this.state = state;
        this.base = base;
        ResourceLocation resourcelocation = new ResourceLocation("extrautils2:connected/" + texture);
        ResourceLocation resourcelocation1 = Textures.completeTextureResourceLocation(resourcelocation);
        try (IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourcelocation1);){
            BufferedImage read = ImageIO.read(iresource.func_110527_b());
            this.hasConnectedTextures = read.getHeight() == read.getWidth() * 5;
        }
        catch (IOException e) {
            this.hasConnectedTextures = false;
        }
        this.baseTextureName = "connected/" + texture;
        if (this.hasConnectedTextures) {
            for (int i : ConnectedTexturesHelper.trueTextures) {
                this.icons[i] = new SpriteConnectedTextures(texture, i);
                Textures.textureNames.put(this.getTexKey(i), this.icons[i]);
            }
        } else {
            Textures.register(this.baseTextureName);
        }
    }

    private static BlockPos multiOffset(BlockPos base, EnumFacing ... sides) {
        for (EnumFacing side : sides) {
            if (side == null) continue;
            base = base.func_177972_a(side);
        }
        return base;
    }

    public String getTexKey(int i) {
        if (this.hasConnectedTextures) {
            return this.baseTextureName + "#" + i;
        }
        return this.baseTextureName;
    }

    protected boolean matches(IBlockAccess world, BlockPos pos, EnumFacing side, BlockPos originalPos) {
        IBlockState b = world.func_180495_p(pos);
        return b == this.state && b.func_185894_c(world, pos, side);
    }

    @Override
    public List<TextureComponent> getComposites(IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        if (side == null) {
            return null;
        }
        if (!this.hasConnectedTextures) {
            return ISolidWorldTexture.handleTexture(this.getBaseTexture());
        }
        EnumFacing u = up[side.func_176745_a()];
        EnumFacing l = left[side.func_176745_a()];
        EnumFacing r = l.func_176734_d();
        EnumFacing d = u.func_176734_d();
        int ar = 0;
        ar += this.matches(world, blockPos, side, u);
        ar += this.matches(world, blockPos, side, r) * 2;
        ar += this.matches(world, blockPos, side, d) * 4;
        if (!ConnectedTexturesHelper.isAdvancedArrangement[ar += this.matches(world, blockPos, side, l) * 8]) {
            return this.getComposites(ConnectedTexturesHelper.textureFromArrangement[ar]);
        }
        ar += this.matches(world, blockPos, side, u, r) * 16;
        ar += this.matches(world, blockPos, side, d, r) * 32;
        ar += this.matches(world, blockPos, side, d, l) * 64;
        return this.getComposites(ConnectedTexturesHelper.textureFromArrangement[ar += this.matches(world, blockPos, side, u, l) * 128]);
    }

    public List<TextureComponent> getComposites(int texID) {
        int[][] texes = ConnectedTexturesHelper.texBounds[texID];
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)texes.length);
        for (int[] tex : texes) {
            arrayList.add(new TextureComponent(this.icons[tex[0]], tex[1], tex[2], tex[3], tex[4]));
        }
        return arrayList;
    }

    @Override
    public TextureAtlasSprite getWorldIcon(IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        if (side == null) {
            return null;
        }
        if (!this.hasConnectedTextures) {
            return this.getBaseTexture();
        }
        EnumFacing u = up[side.func_176745_a()];
        EnumFacing l = left[side.func_176745_a()];
        EnumFacing r = l.func_176734_d();
        EnumFacing d = u.func_176734_d();
        int ar = 0;
        ar += this.matches(world, blockPos, side, u);
        ar += this.matches(world, blockPos, side, r) * 2;
        ar += this.matches(world, blockPos, side, d) * 4;
        if (!ConnectedTexturesHelper.isAdvancedArrangement[ar += this.matches(world, blockPos, side, l) * 8]) {
            return this.icons[ConnectedTexturesHelper.textureFromArrangement[ar]];
        }
        ar += this.matches(world, blockPos, side, u, r) * 16;
        ar += this.matches(world, blockPos, side, d, r) * 32;
        ar += this.matches(world, blockPos, side, d, l) * 64;
        return this.icons[ConnectedTexturesHelper.textureFromArrangement[ar += this.matches(world, blockPos, side, u, l) * 128]];
    }

    @Override
    public String getItemTexture(EnumFacing side) {
        if (this.hasConnectedTextures) {
            return this.getTexKey(ConnectedTexturesHelper.textureFromArrangement[15]);
        }
        return this.baseTextureName;
    }

    public TextureAtlasSprite getBaseTexture() {
        return Textures.getSprite(this.baseTextureName);
    }

    private int matches(IBlockAccess world, BlockPos pos, EnumFacing side, EnumFacing ... dirs) {
        return this.matches(world, ConnectedTexture.multiOffset(pos, dirs), side, pos) ? 0 : 1;
    }
}

