/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.analog;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LogicFacing;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AnalogTileEntity
extends LogicTileEntity {
    public static final String CMD_UPDATE = "analog.update";
    public static final Key<Double> PARAM_MUL_EQ = new Key("mul_eq", Type.DOUBLE);
    public static final Key<Double> PARAM_MUL_LESS = new Key("mul_less", Type.DOUBLE);
    public static final Key<Double> PARAM_MUL_GT = new Key("mul_gt", Type.DOUBLE);
    public static final Key<Integer> PARAM_ADD_EQ = new Key("add_eq", Type.INTEGER);
    public static final Key<Integer> PARAM_ADD_LESS = new Key("add_less", Type.INTEGER);
    public static final Key<Integer> PARAM_ADD_GT = new Key("add_gt", Type.INTEGER);
    private float mulEqual = 1.0f;
    private float mulLess = 1.0f;
    private float mulGreater = 1.0f;
    private int addEqual = 0;
    private int addLess = 0;
    private int addGreater = 0;
    private static Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public float getMulEqual() {
        return this.mulEqual;
    }

    public void setMulEqual(float mulEqual) {
        this.mulEqual = mulEqual;
        this.markDirtyQuick();
    }

    public float getMulLess() {
        return this.mulLess;
    }

    public void setMulLess(float mulLess) {
        this.mulLess = mulLess;
        this.markDirtyQuick();
    }

    public float getMulGreater() {
        return this.mulGreater;
    }

    public void setMulGreater(float mulGreater) {
        this.mulGreater = mulGreater;
        this.markDirtyQuick();
    }

    public int getAddEqual() {
        return this.addEqual;
    }

    public void setAddEqual(int addEqual) {
        this.addEqual = addEqual;
    }

    public int getAddLess() {
        return this.addLess;
    }

    public void setAddLess(int addLess) {
        this.addLess = addLess;
    }

    public int getAddGreater() {
        return this.addGreater;
    }

    public void setAddGreater(int addGreater) {
        this.addGreater = addGreater;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.mulEqual = tagCompound.func_74760_g("mulE");
        this.mulLess = tagCompound.func_74760_g("mulL");
        this.mulGreater = tagCompound.func_74760_g("mulG");
        this.addEqual = tagCompound.func_74762_e("addE");
        this.addLess = tagCompound.func_74762_e("addL");
        this.addGreater = tagCompound.func_74762_e("addG");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74776_a("mulE", this.mulEqual);
        tagCompound.func_74776_a("mulL", this.mulLess);
        tagCompound.func_74776_a("mulG", this.mulGreater);
        tagCompound.func_74768_a("addE", this.addEqual);
        tagCompound.func_74768_a("addL", this.addLess);
        tagCompound.func_74768_a("addG", this.addGreater);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_UPDATE.equals(command)) {
            this.mulEqual = ((Double)params.get(PARAM_MUL_EQ)).floatValue();
            this.mulLess = ((Double)params.get(PARAM_MUL_LESS)).floatValue();
            this.mulGreater = ((Double)params.get(PARAM_MUL_GT)).floatValue();
            this.addEqual = (Integer)params.get(PARAM_ADD_EQ);
            this.addLess = (Integer)params.get(PARAM_ADD_LESS);
            this.addGreater = (Integer)params.get(PARAM_ADD_GT);
            this.markDirtyClient();
            this.checkRedstone(this.field_145850_b, this.field_174879_c);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRedstone(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (loopDetector.add(pos)) {
            try {
                LogicFacing facing = this.getFacing(state);
                EnumFacing downSide = facing.getSide();
                EnumFacing inputSide = facing.getInputSide();
                EnumFacing rightSide = LogicSlabBlock.rotateLeft((EnumFacing)downSide, (EnumFacing)inputSide);
                EnumFacing leftSide = LogicSlabBlock.rotateRight((EnumFacing)downSide, (EnumFacing)inputSide);
                int inputStrength = this.getInputStrength(world, pos, inputSide);
                int inputLeft = this.getInputStrength(world, pos, leftSide);
                int inputRight = this.getInputStrength(world, pos, rightSide);
                int outputStrength = inputLeft == inputRight ? (int)((float)inputStrength * this.getMulEqual() + (float)this.getAddEqual()) : (inputLeft < inputRight ? (int)((float)inputStrength * this.getMulLess() + (float)this.getAddLess()) : (int)((float)inputStrength * this.getMulGreater() + (float)this.getAddGreater()));
                if (outputStrength > 15) {
                    outputStrength = 15;
                } else if (outputStrength < 0) {
                    outputStrength = 0;
                }
                int oldPower = this.getPowerLevel();
                this.setPowerInput(outputStrength);
                if (oldPower != outputStrength) {
                    world.func_175685_c(pos, this.func_145838_q(), false);
                }
            }
            finally {
                loopDetector.remove(pos);
            }
        }
    }

    public int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == this.getFacing(state).getInputSide()) {
            return this.getPowerLevel();
        }
        return 0;
    }
}

