/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.tile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.dave.compactmachines3.block.BlockFieldProjector;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.miniaturization.MultiblockRecipe;
import org.dave.compactmachines3.miniaturization.MultiblockRecipes;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.tile.TileEntityCraftingHologram;
import org.dave.compactmachines3.world.tools.StructureTools;

public class TileEntityFieldProjector
extends TileEntity
implements ITickable {
    public int ticks = 0;
    private int activeMagnitude = 0;
    protected UUID owner;

    public EnumFacing getDirection() {
        if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() == Blockss.fieldProjector) {
            return (EnumFacing)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFieldProjector.FACING);
        }
        return EnumFacing.NORTH;
    }

    public TileEntityCraftingHologram getCraftingHologram() {
        if (this.activeMagnitude == 0) {
            return null;
        }
        BlockPos center = this.func_174877_v().func_177967_a(this.getDirection(), this.activeMagnitude * 2);
        if (this.func_145831_w().func_175625_s(center) instanceof TileEntityCraftingHologram) {
            return (TileEntityCraftingHologram)this.func_145831_w().func_175625_s(center);
        }
        return null;
    }

    public int getActiveMagnitude() {
        return this.activeMagnitude;
    }

    public int getCraftingProgress() {
        TileEntityCraftingHologram te = this.getCraftingHologram();
        if (te == null) {
            return 0;
        }
        return te.getProgress();
    }

    public float getCraftingProgressPercent() {
        TileEntityCraftingHologram te = this.getCraftingHologram();
        if (te == null) {
            return 0.0f;
        }
        if (te.getRecipe() == null) {
            return 0.0f;
        }
        return (float)te.getProgress() / (float)te.getRecipe().getTicks();
    }

    public MultiblockRecipe getActiveRecipe() {
        TileEntityCraftingHologram te = this.getCraftingHologram();
        if (te == null) {
            return null;
        }
        return te.getRecipe();
    }

    public ItemStack getActiveCraftingResult() {
        if (this.getActiveRecipe() == null) {
            return ItemStack.field_190927_a;
        }
        return this.getActiveRecipe().getTargetStack();
    }

    public List<BlockPos> getInsideBlocks() {
        if (this.activeMagnitude == 0) {
            return Collections.emptyList();
        }
        int fieldDimension = this.activeMagnitude * 2 - 1;
        int fieldRadius = (fieldDimension + 1) / 2;
        BlockPos frontTopLeft = this.func_174877_v().func_177967_a(this.getDirection(), this.activeMagnitude + 1).func_177967_a(EnumFacing.UP, fieldRadius - 1).func_177967_a(this.getDirection().func_176735_f(), fieldRadius - 1);
        ArrayList<BlockPos> insideBlocks = new ArrayList<BlockPos>();
        for (int x = 0; x < fieldDimension; ++x) {
            for (int y = 0; y < fieldDimension; ++y) {
                for (int z = 0; z < fieldDimension; ++z) {
                    BlockPos blockToCheck = frontTopLeft.func_177967_a(this.getDirection(), x).func_177967_a(EnumFacing.DOWN, y).func_177967_a(this.getDirection().func_176746_e(), z);
                    if (this.func_145831_w().func_175623_d(blockToCheck)) continue;
                    insideBlocks.add(blockToCheck);
                }
            }
        }
        return insideBlocks;
    }

    private TileEntityFieldProjector getMasterByAddingDirections(EnumFacing A, EnumFacing B) {
        for (int size = 1; size < ConfigurationHandler.Settings.getMaximumMagnitude(); ++size) {
            TileEntityFieldProjector te;
            BlockPos pos = this.func_174877_v().func_177967_a(A, size).func_177967_a(B, size);
            if (!(this.func_145831_w().func_175625_s(pos) instanceof TileEntityFieldProjector) || !(te = (TileEntityFieldProjector)this.func_145831_w().func_175625_s(pos)).isMaster()) continue;
            return te;
        }
        return null;
    }

    public TileEntityFieldProjector getMasterProjector() {
        if (this.isMaster()) {
            return this;
        }
        if (this.getDirection() == EnumFacing.EAST) {
            return this.getMasterByAddingDirections(EnumFacing.EAST, EnumFacing.EAST);
        }
        if (this.getDirection() == EnumFacing.NORTH) {
            return this.getMasterByAddingDirections(EnumFacing.NORTH, EnumFacing.EAST);
        }
        if (this.getDirection() == EnumFacing.SOUTH) {
            return this.getMasterByAddingDirections(EnumFacing.SOUTH, EnumFacing.EAST);
        }
        return null;
    }

    public boolean isMaster() {
        return this.getDirection() == EnumFacing.WEST;
    }

    public List<BlockPos> getMissingProjectors(int magnitude) {
        IBlockState ccwState;
        IBlockState cwState;
        int radius = magnitude * 2;
        BlockPos center = this.func_174877_v().func_177967_a(this.getDirection(), radius);
        BlockPos opposite = center.func_177967_a(this.getDirection(), radius);
        BlockPos cw = center.func_177967_a(this.getDirection().func_176746_e(), radius);
        BlockPos ccw = center.func_177967_a(this.getDirection().func_176735_f(), radius);
        ArrayList<BlockPos> missingBlocks = new ArrayList<BlockPos>();
        IBlockState oppositeState = this.field_145850_b.func_180495_p(opposite);
        if (oppositeState.func_177230_c() != Blockss.fieldProjector || oppositeState.func_177229_b((IProperty)BlockFieldProjector.FACING) != this.getDirection().func_176734_d() || this.field_145850_b.func_175640_z(opposite)) {
            missingBlocks.add(opposite);
        }
        if ((cwState = this.field_145850_b.func_180495_p(cw)).func_177230_c() != Blockss.fieldProjector || cwState.func_177229_b((IProperty)BlockFieldProjector.FACING) != this.getDirection().func_176746_e().func_176734_d() || this.field_145850_b.func_175640_z(cw)) {
            missingBlocks.add(cw);
        }
        if ((ccwState = this.field_145850_b.func_180495_p(ccw)).func_177230_c() != Blockss.fieldProjector || ccwState.func_177229_b((IProperty)BlockFieldProjector.FACING) != this.getDirection().func_176735_f().func_176734_d() || this.field_145850_b.func_175640_z(ccw)) {
            missingBlocks.add(ccw);
        }
        return missingBlocks;
    }

    public int getCraftingAreaMagnitude() {
        for (int magnitude = 1; magnitude <= ConfigurationHandler.Settings.getMaximumMagnitude() + 1; ++magnitude) {
            BlockPos opposite = this.func_174877_v().func_177967_a(this.getDirection(), magnitude * 4);
            if (!(this.field_145850_b.func_175625_s(opposite) instanceof TileEntityFieldProjector)) continue;
            return magnitude;
        }
        return 0;
    }

    public boolean canGenerateFieldAtMagnitude(int magnitude) {
        if (!this.isMaster()) {
            return false;
        }
        return this.getInvalidBlockInField(magnitude) == null;
    }

    public BlockPos getInvalidBlockInField(int magnitude) {
        if (!this.isMaster()) {
            return null;
        }
        int fieldDimension = (magnitude + 1) * 2 - 1;
        BlockPos center = this.func_174877_v().func_177967_a(this.getDirection(), magnitude);
        BlockPos topLeft = center.func_177967_a(EnumFacing.UP, magnitude).func_177967_a(this.getDirection().func_176735_f(), magnitude);
        List<BlockPos> positionsToCheck = StructureTools.getCubePositions(topLeft, fieldDimension, fieldDimension, fieldDimension, false);
        for (BlockPos pos : positionsToCheck) {
            if (this.func_145831_w().func_175623_d(pos)) continue;
            return pos;
        }
        return null;
    }

    public boolean shouldRenderField() {
        if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
            return false;
        }
        int magnitude = this.getCraftingAreaMagnitude();
        if (magnitude <= 1) {
            return false;
        }
        if (this.getMissingProjectors(magnitude).size() > 0) {
            return false;
        }
        TileEntityFieldProjector master = this.getMasterProjector();
        if (master == null) {
            return false;
        }
        return master.canGenerateFieldAtMagnitude(magnitude);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() == Blockss.fieldProjector) {
            BlockPos centerOfField = this.func_174877_v().func_177967_a(this.getDirection(), this.getActiveMagnitude() * 2);
            AxisAlignedBB cube = new AxisAlignedBB(centerOfField).func_186662_g((double)(this.getActiveMagnitude() * 3));
            return cube;
        }
        return super.getRenderBoundingBox();
    }

    public void func_73660_a() {
        ++this.ticks;
        if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
            return;
        }
        int magnitude = this.getCraftingAreaMagnitude();
        if (magnitude <= 1) {
            return;
        }
        if (this.getMissingProjectors(magnitude).size() > 0) {
            this.activeMagnitude = 0;
            return;
        }
        TileEntityFieldProjector master = this.getMasterProjector();
        if (master == null) {
            return;
        }
        if (!master.canGenerateFieldAtMagnitude(magnitude)) {
            return;
        }
        this.activeMagnitude = magnitude;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (master.getActiveRecipe() != null) {
            this.field_145850_b.func_175666_e(this.func_174877_v(), null);
            return;
        }
        BlockPos center = this.func_174877_v().func_177967_a(this.getDirection(), magnitude * 2);
        double growWD = (double)magnitude + 0.5;
        BlockPos centerPosOfField = this.func_174877_v().func_177967_a(this.getDirection(), magnitude);
        AxisAlignedBB centerBB = new AxisAlignedBB(centerPosOfField).func_72314_b(0.0, growWD, 0.0);
        centerBB = this.getDirection() == EnumFacing.NORTH || this.getDirection() == EnumFacing.SOUTH ? centerBB.func_72314_b(growWD, 0.0, 0.0) : centerBB.func_72314_b(0.0, 0.0, growWD);
        List items = this.field_145850_b.func_72872_a(EntityItem.class, centerBB);
        if (this.isMaster()) {
            BlockPos centerOfTopField = this.func_174877_v().func_177967_a(this.getDirection(), magnitude * 2).func_177967_a(EnumFacing.UP, magnitude);
            AxisAlignedBB topBB = new AxisAlignedBB(centerOfTopField).func_72314_b((double)magnitude + 0.5, 0.0, (double)magnitude + 0.5);
            items.addAll(this.field_145850_b.func_72872_a(EntityItem.class, topBB));
        }
        for (EntityItem item : items) {
            MultiblockRecipe multiblockRecipe;
            if (item.field_70173_aa > ConfigurationHandler.Settings.maximumCraftingCatalystAge || (multiblockRecipe = MultiblockRecipes.tryCrafting(this.field_145850_b, this.func_174877_v(), item.func_92059_d())) == null) continue;
            for (BlockPos pos : this.getInsideBlocks()) {
                this.field_145850_b.func_175698_g(pos);
                ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10, 0.5, 0.5, 0.5, 0.01, new int[0]);
            }
            ItemStack stack = item.func_92059_d();
            if (stack.func_190916_E() == 1) {
                item.func_70106_y();
            } else if (stack.func_190916_E() > 1) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                item.func_92058_a(stack.func_77946_l());
            }
            this.field_145850_b.func_175656_a(center, Blockss.craftingHologram.func_176223_P());
            TileEntityCraftingHologram teHologram = (TileEntityCraftingHologram)this.field_145850_b.func_175625_s(center);
            if (teHologram == null) continue;
            teHologram.setRecipe(multiblockRecipe);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.owner = compound.func_186857_a("owner");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.hasOwner()) {
            compound.func_186854_a("owner", this.owner);
        }
        return compound;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(this.getOwner()).getName();
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setOwner(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.setOwner(player.func_110124_au());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

