/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.variables;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.util.random.WeightedString;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.List;

public class StringData {
    public static boolean parseStringList(ConfigValue stringEntry, List<WeightedString> list) {
        if (stringEntry.valueType() == ConfigValueType.LIST) {
            ConfigList configList = (ConfigList)stringEntry;
            int e = configList.size();
            for (int i = 0; i < e; ++i) {
                WeightedString entry = StringData.parseStringEntry((ConfigValue)configList.get(i));
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            WeightedString entry = StringData.parseStringEntry(stringEntry);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static WeightedString parseStringEntry(ConfigValue stringEntry) {
        int weight = 100;
        String value = null;
        switch (stringEntry.valueType()) {
            case LIST: {
                CoFHWorld.log.warn("Lists are not supported for string values at line {}.", (Object)stringEntry.origin().lineNumber());
                return null;
            }
            case NULL: {
                CoFHWorld.log.warn("Null string entry at line {}", (Object)stringEntry.origin().lineNumber());
                return null;
            }
            case OBJECT: {
                Config stringObject = ((ConfigObject)stringEntry).toConfig();
                if (stringObject.hasPath("name")) {
                    value = stringObject.getString("name");
                } else {
                    CoFHWorld.log.warn("Value missing 'name' field at line {}", (Object)stringEntry.origin().lineNumber());
                }
                if (!stringObject.hasPath("weight")) break;
                weight = stringObject.getInt("weight");
                break;
            }
            case BOOLEAN: 
            case NUMBER: 
            case STRING: {
                value = String.valueOf(stringEntry.unwrapped());
            }
        }
        return new WeightedString(value, weight);
    }
}

