/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidUtil
implements IFluidHandlerItem,
ICapabilityProvider {
    private ItemStack container;
    private int capacity;
    private FluidStack fluid;

    public FluidUtil(ItemStack container, int capacity, FluidStack fluid) {
        this.container = container;
        this.capacity = capacity;
        this.fluid = fluid;
    }

    public FluidUtil(ItemStack container, int capacity, Fluid fluid) {
        this.container = container;
        this.capacity = capacity;
        this.fluid = new FluidStack(fluid, capacity);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.fluid, this.capacity)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0 || !resource.isFluidEqual(this.fluid)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || maxDrain <= 0) {
            return null;
        }
        if (this.fluid == null || this.fluid.amount <= 0) {
            return null;
        }
        int drainAmount = Math.min(this.fluid.amount, maxDrain);
        FluidStack drained = this.fluid.copy();
        drained.amount = drainAmount;
        if (doDrain) {
            // empty if block
        }
        return drained;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

