/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import net.ndrei.teslacorelib.inventory.IFilteredFluidTank;
import net.ndrei.teslacorelib.inventory.IFluidTankWrapper;
import net.ndrei.teslacorelib.inventory.ITypedFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lnet/ndrei/teslacorelib/inventory/FilteredFluidTank;", "Lnet/ndrei/teslacorelib/inventory/IFilteredFluidTank;", "Lnet/ndrei/teslacorelib/inventory/IFluidTankWrapper;", "Lnet/ndrei/teslacorelib/inventory/ITypedFluidTank;", "tank", "Lnet/minecraftforge/fluids/IFluidTank;", "(Lnet/minecraftforge/fluids/IFluidTank;)V", "filter", "Lnet/minecraftforge/fluids/Fluid;", "(Lnet/minecraftforge/fluids/Fluid;Lnet/minecraftforge/fluids/IFluidTank;)V", "innerTank", "getInnerTank", "()Lnet/minecraftforge/fluids/IFluidTank;", "tankType", "Lnet/ndrei/teslacorelib/inventory/FluidTankType;", "getTankType", "()Lnet/ndrei/teslacorelib/inventory/FluidTankType;", "setTankType", "(Lnet/ndrei/teslacorelib/inventory/FluidTankType;)V", "acceptsFluid", "", "fluid", "Lnet/minecraftforge/fluids/FluidStack;", "canDrain", "canFill", "drain", "maxDrain", "", "doDrain", "fill", "resource", "doFill", "getCapacity", "getFluid", "getFluidAmount", "getInfo", "Lnet/minecraftforge/fluids/FluidTankInfo;", "tesla-core-lib"})
public class FilteredFluidTank
implements IFilteredFluidTank,
IFluidTankWrapper,
ITypedFluidTank {
    @NotNull
    private FluidTankType tankType;
    private final Fluid filter;
    private final IFluidTank tank;

    @Override
    public boolean acceptsFluid(@NotNull FluidStack fluid) {
        Intrinsics.checkParameterIsNotNull((Object)fluid, (String)"fluid");
        return this.filter == null || fluid.getFluid() == this.filter;
    }

    @Override
    public boolean canDrain() {
        return true;
    }

    @Override
    public boolean canFill() {
        return true;
    }

    @Override
    @NotNull
    public FluidTankType getTankType() {
        return this.tankType;
    }

    public void setTankType(@NotNull FluidTankType fluidTankType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fluidTankType), (String)"<set-?>");
        this.tankType = fluidTankType;
    }

    @Nullable
    public FluidStack getFluid() {
        FluidStack stack = this.tank.getFluid();
        if (stack == null && this.filter != null) {
            stack = new FluidStack(this.filter, 0);
        }
        return stack;
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    @NotNull
    public FluidTankInfo getInfo() {
        FluidTankInfo fluidTankInfo = this.tank.getInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidTankInfo, (String)"this.tank.info");
        return fluidTankInfo;
    }

    public int fill(@NotNull FluidStack resource, boolean doFill) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        if (!this.canFill() || !this.acceptsFluid(resource)) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrain()) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    @NotNull
    public IFluidTank getInnerTank() {
        return this.tank;
    }

    public FilteredFluidTank(@Nullable Fluid filter, @NotNull IFluidTank tank2) {
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        this.filter = filter;
        this.tank = tank2;
        this.tankType = FluidTankType.BOTH;
    }

    public FilteredFluidTank(@NotNull IFluidTank tank2) {
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        this(null, tank2);
    }
}

