/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerConfigurable;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMechanicalMachine;

public class GuiMechanicalMachine<C extends ContainerMechanicalMachine<?>>
extends GuiContainerConfigurable<C> {
    public GuiMechanicalMachine(C container) {
        super(container);
    }

    public void drawEnergyBarTooltip(int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((GuiContainer)this, (int)8, (int)16, (int)18, (int)60, (int)mouseX, (int)mouseY, () -> {
            int energyStored = ((ContainerMechanicalMachine)this.getContainer()).getEnergy();
            int energyMax = ((ContainerMechanicalMachine)this.getContainer()).getMaxEnergy();
            if (energyMax > 0) {
                return Optional.of(Lists.newArrayList((Object[])new String[]{Helpers.getLocalizedEnergyLevel(energyStored, energyMax)}));
            }
            return Optional.empty();
        });
    }

    public void drawFluidTankTooltip(FluidStack fluidStack, int fluidCapacity, int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((GuiContainer)this, (int)x, (int)y, (int)width, (int)height, (int)mouseX, (int)mouseY, () -> {
            if (fluidStack != null) {
                String fluidName = fluidStack.getLocalizedName();
                return Optional.of(Lists.newArrayList((Object[])new String[]{fluidName, DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)fluidStack.amount, (int)fluidCapacity)}));
            }
            return Optional.empty();
        });
    }
}

