/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;

public class CurriedOperator
implements IOperator {
    private final IOperator baseOperator;
    private final IVariable[] appliedVariables;

    public CurriedOperator(IOperator baseOperator, IVariable ... appliedVariables) {
        this.baseOperator = baseOperator;
        this.appliedVariables = appliedVariables;
    }

    protected String getAppliedSymbol() {
        String symbol = "";
        for (IVariable appliedVariable : this.appliedVariables) {
            symbol = symbol + appliedVariable.getType().getTypeName() + ";";
        }
        return symbol;
    }

    @Override
    public String getSymbol() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseOperator.getSymbol());
        sb.append(" [");
        sb.append(this.getAppliedSymbol());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getUniqueName() {
        return "curriedOperator";
    }

    @Override
    public String getTranslationKey() {
        return this.baseOperator.getTranslationKey();
    }

    @Override
    public String getUnlocalizedCategoryName() {
        return this.baseOperator.getUnlocalizedCategoryName();
    }

    @Override
    public String getLocalizedNameFull() {
        return L10NHelpers.localize((String)"operator.integrateddynamics.applied.operator_name", (Object[])new Object[]{this.baseOperator.getLocalizedNameFull(), this.getAppliedSymbol()});
    }

    @Override
    public void loadTooltip(List<String> lines, boolean appendOptionalInfo) {
        this.baseOperator.loadTooltip(lines, appendOptionalInfo);
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.applied.type", (Object[])new Object[]{this.getAppliedSymbol()}));
    }

    @Override
    public IValueType[] getInputTypes() {
        IValueType[] baseInputTypes = this.baseOperator.getInputTypes();
        return Arrays.copyOfRange(baseInputTypes, this.appliedVariables.length, baseInputTypes.length);
    }

    @Override
    public IValueType getOutputType() {
        return this.baseOperator.getOutputType();
    }

    protected IVariable[] deriveFullInputVariables(IVariable[] partialInput) {
        IVariable[] fullInput = new IVariable[Math.min(this.baseOperator.getRequiredInputLength(), partialInput.length + this.appliedVariables.length)];
        for (int i = 0; i < this.appliedVariables.length; ++i) {
            fullInput[i] = this.appliedVariables[i];
        }
        System.arraycopy(partialInput, 0, fullInput, this.appliedVariables.length, fullInput.length - this.appliedVariables.length);
        return fullInput;
    }

    protected IValueType[] deriveFullInputTypes(IValueType[] partialInput) {
        IValueType[] fullInput = new IValueType[Math.min(this.baseOperator.getRequiredInputLength(), partialInput.length + this.appliedVariables.length)];
        for (int i = 0; i < this.appliedVariables.length; ++i) {
            fullInput[i] = this.appliedVariables[i].getType();
        }
        System.arraycopy(partialInput, 0, fullInput, this.appliedVariables.length, fullInput.length - this.appliedVariables.length);
        return fullInput;
    }

    @Override
    public IValueType getConditionalOutputType(IVariable[] input) {
        return this.baseOperator.getConditionalOutputType(this.deriveFullInputVariables(input));
    }

    @Override
    public IValue evaluate(IVariable[] input) throws EvaluationException {
        return this.baseOperator.evaluate(this.deriveFullInputVariables(input));
    }

    @Override
    public int getRequiredInputLength() {
        return this.baseOperator.getRequiredInputLength() - this.appliedVariables.length;
    }

    @Override
    public L10NHelpers.UnlocalizedString validateTypes(IValueType[] input) {
        return this.baseOperator.validateTypes(this.deriveFullInputTypes(input));
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE;
    }

    @Override
    public IOperator materialize() throws EvaluationException {
        IVariable[] variables = new IVariable[this.appliedVariables.length];
        for (int i = 0; i < this.appliedVariables.length; ++i) {
            IVariable appliedVariable = this.appliedVariables[i];
            variables[i] = new Variable(appliedVariable.getType(), appliedVariable.getValue());
        }
        return new CurriedOperator(this.baseOperator, variables);
    }

    public IOperator getBaseOperator() {
        return this.baseOperator;
    }

    public static class Serializer
    implements IOperatorSerializer<CurriedOperator> {
        @Override
        public boolean canHandle(IOperator operator) {
            return operator instanceof CurriedOperator;
        }

        @Override
        public String getUniqueName() {
            return "curry";
        }

        @Override
        public String serialize(CurriedOperator operator) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < operator.appliedVariables.length; ++i) {
                Object value;
                IVariable appliedVariable = operator.appliedVariables[i];
                try {
                    value = appliedVariable.getValue();
                }
                catch (EvaluationException e) {
                    value = appliedVariable.getType().getDefault();
                }
                NBTTagCompound valueTag = new NBTTagCompound();
                IValueType valueType = value.getType();
                valueTag.func_74778_a("valueType", valueType.getTranslationKey());
                valueTag.func_74778_a("value", ValueHelpers.serializeRaw(value));
                list.func_74742_a((NBTBase)valueTag);
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("values", (NBTBase)list);
            tag.func_74778_a("baseOperator", Operators.REGISTRY.serialize(operator.baseOperator));
            return tag.toString();
        }

        @Override
        public CurriedOperator deserialize(String valueOperator) throws EvaluationException {
            NBTTagCompound tag;
            try {
                tag = JsonToNBT.func_180713_a((String)valueOperator);
            }
            catch (NBTException e) {
                e.printStackTrace();
                throw new EvaluationException(e.getMessage());
            }
            NBTTagList list = tag.func_150295_c("values", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
            IVariable[] variables = new IVariable[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound valuetag = list.func_150305_b(i);
                IValueType valueType = ValueTypes.REGISTRY.getValueType(valuetag.func_74779_i("valueType"));
                Object value = ValueHelpers.deserializeRaw(valueType, valuetag.func_74779_i("value"));
                variables[i] = new Variable(valueType, value);
            }
            IOperator baseOperator = Objects.requireNonNull(Operators.REGISTRY.deserialize(tag.func_74779_i("baseOperator")));
            return new CurriedOperator(baseOperator, variables);
        }
    }
}

