/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.base.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeBlock
extends ValueObjectTypeBase<ValueBlock>
implements IValueTypeNamed<ValueBlock>,
IValueTypeUniquelyNamed<ValueBlock>,
IValueTypeNullable<ValueBlock> {
    public ValueObjectTypeBlock() {
        super("block");
    }

    public static String getBlockDisplayNameUsSafe(IBlockState blockState) throws NoSuchMethodException {
        return blockState.func_177230_c().func_149732_F();
    }

    public static String getBlockkDisplayNameSafe(IBlockState blockState) {
        try {
            return ValueObjectTypeBlock.getBlockDisplayNameUsSafe(blockState);
        }
        catch (NoSuchMethodException e) {
            return L10NHelpers.localize((String)(blockState.func_177230_c().func_149739_a() + ".name"), (Object[])new Object[0]);
        }
    }

    @Override
    public ValueBlock getDefault() {
        return ValueBlock.of(Blocks.field_150350_a.func_176223_P());
    }

    @Override
    public String toCompactString(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            IBlockState blockState = (IBlockState)value.getRawValue().get();
            ItemStack itemStack = BlockHelpers.getItemStackFromBlockState((IBlockState)blockState);
            if (!itemStack.func_190926_b()) {
                return ValueObjectTypeItemStack.getItemStackDisplayNameSafe(itemStack);
            }
            return ValueObjectTypeBlock.getBlockkDisplayNameSafe(blockState);
        }
        return "";
    }

    @Override
    public String serialize(ValueBlock value) {
        if (!value.getRawValue().isPresent()) {
            return "";
        }
        Pair serializedBlockState = BlockHelpers.serializeBlockState((IBlockState)((IBlockState)value.getRawValue().get()));
        return String.format("%s$%s", serializedBlockState.getLeft(), serializedBlockState.getRight());
    }

    @Override
    public ValueBlock deserialize(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return ValueBlock.of(Blocks.field_150350_a.func_176223_P());
        }
        String[] parts = value.split("\\$");
        try {
            return ValueBlock.of(BlockHelpers.deserializeBlockState((Pair)Pair.of((Object)parts[0], (Object)Integer.parseInt(parts[1]))));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("Something went wrong while deserializing '%s'.", value));
        }
    }

    @Override
    public String getName(ValueBlock a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueBlock a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueBlock>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueBlock>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public L10NHelpers.UnlocalizedString validate(ItemStack itemStack) {
                if (!itemStack.func_190926_b() && !(itemStack.func_77973_b() instanceof ItemBlock)) {
                    return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.block.no_block", new Object[0]);
                }
                return null;
            }

            @Override
            public ValueBlock getValue(ItemStack itemStack) {
                return ValueBlock.of(itemStack.func_190926_b() ? Blocks.field_150350_a.func_176223_P() : BlockHelpers.getBlockStateFromItemStack((ItemStack)itemStack));
            }
        });
    }

    @Override
    public String getUniqueName(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            IBlockState blockState = (IBlockState)value.getRawValue().get();
            int meta = blockState.func_177230_c().func_176201_c(blockState);
            return blockState.func_177230_c().getRegistryName() + (meta > 0 ? " " + meta : "");
        }
        return "";
    }

    public static class ValueBlock
    extends ValueOptionalBase<IBlockState> {
        private ValueBlock(IBlockState blockState) {
            super(ValueTypes.OBJECT_BLOCK, blockState);
        }

        public static ValueBlock of(IBlockState blockState) {
            return new ValueBlock(blockState);
        }

        @Override
        protected boolean isEqual(IBlockState a, IBlockState b) {
            Block blockB;
            Block blockA = a.func_177230_c();
            return blockA == (blockB = b.func_177230_c()) && blockA.func_176201_c(a) == blockB.func_176201_c(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeBlock.ValueBlock()";
        }
    }
}

