/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.IngredientChannelAdapter;

public class IngredientChannelAdapterWrapperSlotted<T, M>
implements IIngredientComponentStorageSlotted<T, M> {
    private final IngredientChannelAdapter<T, M> channel;

    public IngredientChannelAdapterWrapperSlotted(IngredientChannelAdapter<T, M> channel) {
        this.channel = channel;
    }

    protected static int getIngredientComponentStorageSize(IIngredientComponentStorage<?, ?> storage) {
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return ((IIngredientComponentStorageSlotted)storage).getSlots();
        }
        return Iterators.size((Iterator)storage.iterator()) + 1;
    }

    public int getSlots() {
        int slots = 0;
        IPositionedAddonsNetworkIngredients<T, M> network = this.channel.getNetwork();
        for (PartPos pos : network.getPositions()) {
            if (!pos.getPos().isLoaded() || network.isPositionDisabled(pos)) continue;
            IIngredientComponentStorage<T, M> storage = network.getPositionedStorage(pos);
            slots = Helpers.addSafe((int)slots, (int)IngredientChannelAdapterWrapperSlotted.getIngredientComponentStorageSize(storage));
        }
        return slots;
    }

    protected Pair<IIngredientComponentStorage<T, M>, Integer> getStorageAndRelativeSlot(int slot) {
        IPositionedAddonsNetworkIngredients<T, M> network = this.channel.getNetwork();
        for (PartPos pos : network.getPositions()) {
            if (!pos.getPos().isLoaded() || network.isPositionDisabled(pos)) continue;
            IIngredientComponentStorage<T, M> storage = network.getPositionedStorage(pos);
            int storageSize = IngredientChannelAdapterWrapperSlotted.getIngredientComponentStorageSize(storage);
            if (slot < storageSize) {
                return Pair.of(storage, (Object)slot);
            }
            slot -= storageSize;
        }
        return Pair.of(null, (Object)-1);
    }

    public T getSlotContents(int slotAbsolute) {
        Pair<IIngredientComponentStorage<T, M>, Integer> storageAndSlot = this.getStorageAndRelativeSlot(slotAbsolute);
        IIngredientComponentStorage storage = (IIngredientComponentStorage)storageAndSlot.getLeft();
        int slotRelative = (Integer)storageAndSlot.getRight();
        if (storage == null) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return (T)((IIngredientComponentStorageSlotted)storage).getSlotContents(slotRelative);
        }
        try {
            return (T)Iterators.get((Iterator)storage.iterator(), (int)slotRelative);
        }
        catch (IndexOutOfBoundsException e) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
    }

    public long getMaxQuantity(int slotAbsolute) {
        Pair<IIngredientComponentStorage<T, M>, Integer> storageAndSlot = this.getStorageAndRelativeSlot(slotAbsolute);
        IIngredientComponentStorage storage = (IIngredientComponentStorage)storageAndSlot.getLeft();
        int slotRelative = (Integer)storageAndSlot.getRight();
        if (storage == null) {
            return 0L;
        }
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return ((IIngredientComponentStorageSlotted)storage).getMaxQuantity(slotRelative);
        }
        return Helpers.castSafe((long)this.getComponent().getMatcher().getMaximumQuantity());
    }

    public T insert(int slotAbsolute, @Nonnull T ingredient, boolean simulate) {
        Pair<IIngredientComponentStorage<T, M>, Integer> storageAndSlot = this.getStorageAndRelativeSlot(slotAbsolute);
        IIngredientComponentStorage storage = (IIngredientComponentStorage)storageAndSlot.getLeft();
        int slotRelative = (Integer)storageAndSlot.getRight();
        if (storage == null) {
            return ingredient;
        }
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return (T)((IIngredientComponentStorageSlotted)storage).insert(slotRelative, ingredient, simulate);
        }
        return (T)storage.insert(ingredient, simulate);
    }

    public T extract(int slotAbsolute, long maxQuantity, boolean simulate) {
        Pair<IIngredientComponentStorage<T, M>, Integer> storageAndSlot = this.getStorageAndRelativeSlot(slotAbsolute);
        IIngredientComponentStorage storage = (IIngredientComponentStorage)storageAndSlot.getLeft();
        int slotRelative = (Integer)storageAndSlot.getRight();
        if (storage == null) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return (T)((IIngredientComponentStorageSlotted)storage).extract(slotRelative, maxQuantity, simulate);
        }
        return (T)storage.extract(maxQuantity, simulate);
    }

    public IngredientComponent<T, M> getComponent() {
        return this.channel.getComponent();
    }

    public Iterator<T> iterator() {
        return this.channel.iterator();
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchCondition) {
        return this.channel.iterator(prototype, matchCondition);
    }

    public long getMaxQuantity() {
        return this.channel.getMaxQuantity();
    }

    public T insert(@Nonnull T ingredient, boolean simulate) {
        return this.channel.insert(ingredient, simulate);
    }

    public T extract(@Nonnull T prototype, M matchCondition, boolean simulate) {
        return this.channel.extract(prototype, matchCondition, simulate);
    }

    public T extract(long maxQuantity, boolean simulate) {
        return this.channel.extract(maxQuantity, simulate);
    }
}

