/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnosticsPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawNetworkData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawObserverData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawPartData;
import org.cyclops.integrateddynamics.network.packet.NetworkDiagnosticsSubscribePacket;
import org.cyclops.integrateddynamics.network.packet.PlayerTeleportPacket;

public class GuiNetworkDiagnostics
extends JFrame {
    private static GuiNetworkDiagnostics gui = null;
    private static JTable tableParts = null;
    private static Vector<String> columnNamesParts = new Vector();
    private static Vector<Vector<Object>> dataParts = new Vector();
    private static DefaultTableModel modelParts;
    private static Multimap<Integer, ObservablePartData> networkDataParts;
    private static JTable tableObservers;
    private static Vector<String> columnNamesObservers;
    private static Vector<Vector<Object>> dataObservers;
    private static DefaultTableModel modelObservers;
    private static Multimap<Integer, ObservableObserverData> networkDataObservers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNetworkData(int id, RawNetworkData rawNetworkData) {
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            PartPos pos;
            Collection previous = networkDataParts.removeAll((Object)id);
            HashSet previousPositionsWithRender = Sets.newHashSet();
            for (Object partData : previous) {
                PartPos pos2 = ((ObservablePartData)partData).toPartPos();
                if (pos2 == null || !NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos2)) continue;
                previousPositionsWithRender.add(pos2);
            }
            if (rawNetworkData != null) {
                ArrayList parts = Lists.newArrayList();
                for (RawPartData rawPartData : rawNetworkData.getParts()) {
                    Object partData = new ObservablePartData(rawNetworkData.getId(), rawNetworkData.getCables(), rawPartData.getDimension(), rawPartData.getPos(), rawPartData.getSide(), rawPartData.getName(), rawPartData.getLast20TicksDurationNs());
                    parts.add(partData);
                    pos = ((ObservablePartData)partData).toPartPos();
                    if (pos == null) continue;
                    previousPositionsWithRender.remove(pos);
                }
                for (Object partPos : previousPositionsWithRender) {
                    NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos((PartPos)partPos);
                }
                networkDataParts.putAll((Object)id, (Iterable)parts);
            }
            Collection previousObservers = networkDataObservers.removeAll((Object)id);
            HashSet previousPositionsWithRenderObservers = Sets.newHashSet();
            for (Object partData : previousObservers) {
                pos = ((ObservableObserverData)partData).toPartPos();
                if (pos == null || !NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos)) continue;
                previousPositionsWithRenderObservers.add(pos);
            }
            if (rawNetworkData != null) {
                ArrayList observers = Lists.newArrayList();
                for (RawObserverData rawPartData : rawNetworkData.getObservers()) {
                    ObservableObserverData partData = new ObservableObserverData(rawNetworkData.getId(), rawPartData.getDimension(), rawPartData.getPos(), rawPartData.getSide(), rawPartData.getName(), rawPartData.getLast20TicksDurationNs());
                    observers.add(partData);
                    PartPos pos3 = partData.toPartPos();
                    if (pos3 == null) continue;
                    previousPositionsWithRenderObservers.remove(pos3);
                }
                for (PartPos partPos : previousPositionsWithRenderObservers) {
                    NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos(partPos);
                }
                networkDataObservers.putAll((Object)id, (Iterable)observers);
            }
        }
        if (gui != null) {
            gui.updateTables();
        }
    }

    public static void clearNetworkData() {
        networkDataParts.clear();
        networkDataObservers.clear();
    }

    public static void start() {
        if (gui == null) {
            gui = new GuiNetworkDiagnostics();
            gui.setTitle(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.title", (Object[])new Object[0]));
            gui.updateTables();
            gui.setSize(750, 500);
            gui.setDefaultCloseOperation(1);
            gui.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GuiNetworkDiagnostics.onCloseGui();
                    super.windowClosing(e);
                }
            });
            gui.setLocationRelativeTo(null);
        }
        gui.setVisible(true);
    }

    protected void updateTables() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Multimap multimap = networkDataParts;
                    synchronized (multimap) {
                        BlockPos pos;
                        Vector<Object> row;
                        columnNamesParts.clear();
                        columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.network", (Object[])new Object[0]));
                        columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.cables", (Object[])new Object[0]));
                        columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.part", (Object[])new Object[0]));
                        columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.ticktime", (Object[])new Object[0]));
                        columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.dimension", (Object[])new Object[0]));
                        columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.position", (Object[])new Object[0]));
                        columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.side", (Object[])new Object[0]));
                        columnNamesParts.addElement("_id");
                        dataParts.clear();
                        int i = 0;
                        for (Object observablePartData : networkDataParts.values()) {
                            row = new Vector<Object>();
                            row.add(((ObservablePartData)observablePartData).getNetworkId());
                            row.add(((ObservablePartData)observablePartData).getNetworkCables());
                            row.add(((ObservablePartData)observablePartData).getName());
                            row.add(String.format("%.6f", (double)((ObservablePartData)observablePartData).getLast20TicksDurationNs() / 20.0 / 1000000.0));
                            row.add(((ObservablePartData)observablePartData).getDimension());
                            pos = ((ObservablePartData)observablePartData).getPos();
                            row.add(String.format("%s / %s / %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                            row.add(((ObservablePartData)observablePartData).getSide().name());
                            row.add(i++);
                            dataParts.addElement(row);
                        }
                        dataObservers.clear();
                        i = 0;
                        for (ObservableObserverData observableObserverData : networkDataObservers.values()) {
                            row = new Vector();
                            row.add(observableObserverData.getNetworkId());
                            row.add(observableObserverData.getName());
                            row.add(String.format("%.6f", (double)observableObserverData.getLast20TicksDurationNs() / 20.0 / 1000000.0));
                            row.add(observableObserverData.getDimension());
                            pos = observableObserverData.getPos();
                            row.add(String.format("%s / %s / %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                            row.add(observableObserverData.getSide() == null ? "null" : observableObserverData.getSide().name());
                            row.add(i++);
                            dataObservers.addElement(row);
                        }
                        if (tableParts == null) {
                            tableParts = new JTable();
                            modelParts = new DefaultTableModel(dataParts, columnNamesParts){

                                @Override
                                public Class<?> getColumnClass(int column) {
                                    if (column == 0 || column == 1 || column == 4) {
                                        return Integer.class;
                                    }
                                    if (column == 3) {
                                        return Long.class;
                                    }
                                    return String.class;
                                }
                            };
                            tableParts.setModel(modelParts);
                            tableParts.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

                                @Override
                                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                    ObservablePartData partData = GuiNetworkDiagnostics.getPartDataFromRow(row);
                                    if (partData != null && NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(partData.toPartPos())) {
                                        c.setBackground(Color.CYAN);
                                    } else {
                                        c.setBackground(isSelected ? Color.BLUE : Color.WHITE);
                                    }
                                    return c;
                                }
                            });
                            tableParts.getColumnModel().removeColumn(tableParts.getColumn("_id"));
                            tableParts.setAutoCreateRowSorter(true);
                            tableParts.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent e) {
                                    JTable target;
                                    int row;
                                    ObservablePartData partData;
                                    super.mouseClicked(e);
                                    if (e.getClickCount() == 1 && (partData = GuiNetworkDiagnostics.getPartDataFromRow(row = (target = (JTable)e.getSource()).rowAtPoint(e.getPoint()))) != null) {
                                        PartPos pos = partData.toPartPos();
                                        GuiNetworkDiagnostics.teleportPlayer(e, partData.toPartPos());
                                    }
                                }
                            });
                            columnNamesObservers.clear();
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.network", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.part", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.ticktime", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.dimension", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.position", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.side", (Object[])new Object[0]));
                            columnNamesObservers.addElement("_id");
                            dataObservers.clear();
                            i = 0;
                            for (Object observablePartData : networkDataObservers.values()) {
                                row = new Vector();
                                row.add(((ObservableObserverData)observablePartData).getNetworkId());
                                row.add(((ObservableObserverData)observablePartData).getName());
                                row.add(String.format("%.6f", (double)((ObservableObserverData)observablePartData).getLast20TicksDurationNs() / 20.0 / 1000000.0));
                                row.add(((ObservableObserverData)observablePartData).getDimension());
                                pos = ((ObservableObserverData)observablePartData).getPos();
                                row.add(String.format("%s / %s / %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                                row.add(((ObservableObserverData)observablePartData).getSide().name());
                                row.add(i++);
                                dataObservers.addElement(row);
                            }
                            tableObservers = new JTable();
                            modelObservers = new DefaultTableModel(dataObservers, columnNamesObservers){

                                @Override
                                public Class<?> getColumnClass(int column) {
                                    if (column == 0 || column == 3) {
                                        return Integer.class;
                                    }
                                    if (column == 2) {
                                        return Long.class;
                                    }
                                    return String.class;
                                }
                            };
                            tableObservers.setModel(modelObservers);
                            tableObservers.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

                                @Override
                                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                    ObservableObserverData partData = GuiNetworkDiagnostics.getObserverDataFromRow(row);
                                    if (partData != null && NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(partData.toPartPos())) {
                                        c.setBackground(Color.CYAN);
                                    } else {
                                        c.setBackground(isSelected ? Color.BLUE : Color.WHITE);
                                    }
                                    return c;
                                }
                            });
                            tableObservers.getColumnModel().removeColumn(tableObservers.getColumn("_id"));
                            tableObservers.setAutoCreateRowSorter(true);
                            tableObservers.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent e) {
                                    JTable target;
                                    int row;
                                    ObservableObserverData partData;
                                    super.mouseClicked(e);
                                    if (e.getClickCount() == 1 && (partData = GuiNetworkDiagnostics.getObserverDataFromRow(row = (target = (JTable)e.getSource()).rowAtPoint(e.getPoint()))) != null) {
                                        GuiNetworkDiagnostics.teleportPlayer(e, partData.toPartPos());
                                    }
                                }
                            });
                            JPanel panelMain = new JPanel(new GridLayout(2, 1));
                            JPanel panelParts = new JPanel(new BorderLayout());
                            JPanel panelObservers = new JPanel(new BorderLayout());
                            panelParts.add("North", new JLabel(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.parts", (Object[])new Object[0])));
                            panelParts.add("Center", new JScrollPane(tableParts));
                            panelObservers.add("North", new JLabel(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.observers", (Object[])new Object[0])));
                            panelObservers.add("Center", new JScrollPane(tableObservers));
                            panelMain.add(panelParts);
                            panelMain.add(panelObservers);
                            GuiNetworkDiagnostics.this.add(panelMain);
                            GuiNetworkDiagnostics.this.pack();
                        } else {
                            tableParts.getRowSorter().allRowsChanged();
                            modelParts.fireTableDataChanged();
                            tableObservers.getRowSorter().allRowsChanged();
                            modelObservers.fireTableDataChanged();
                        }
                        GuiNetworkDiagnostics.this.repaint();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ObservablePartData getPartDataFromRow(int row) {
        Object[] data;
        if (row < 0) {
            return null;
        }
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            data = networkDataParts.values().toArray();
        }
        int internalId = (Integer)tableParts.getModel().getValueAt(tableParts.convertRowIndexToModel(row), 7);
        if (internalId < data.length) {
            return (ObservablePartData)data[internalId];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ObservableObserverData getObserverDataFromRow(int row) {
        Object[] data;
        if (row < 0) {
            return null;
        }
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            data = networkDataObservers.values().toArray();
        }
        int internalId = (Integer)tableObservers.getModel().getValueAt(tableObservers.convertRowIndexToModel(row), 6);
        if (internalId < data.length) {
            return (ObservableObserverData)data[internalId];
        }
        return null;
    }

    protected static void onCloseGui() {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)NetworkDiagnosticsSubscribePacket.unsubscribe());
        NetworkDiagnosticsPartOverlayRenderer.getInstance().clearPositions();
    }

    protected static void teleportPlayer(MouseEvent e, PartPos pos) {
        if (e.getButton() == 1) {
            if (NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos)) {
                NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos(pos);
            } else {
                NetworkDiagnosticsPartOverlayRenderer.getInstance().addPos(pos);
            }
        } else if (e.getButton() == 3) {
            BlockPos blockPos = pos.getPos().getBlockPos().func_177972_a(pos.getSide());
            float yaw = pos.getSide().func_176734_d().func_185119_l();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new PlayerTeleportPacket(pos.getPos().getDimensionId(), blockPos.func_177958_n(), blockPos.func_177956_o() - 1, blockPos.func_177952_p(), yaw, 0.0f));
        }
    }

    static {
        networkDataParts = ArrayListMultimap.create();
        tableObservers = null;
        columnNamesObservers = new Vector();
        dataObservers = new Vector();
        networkDataObservers = ArrayListMultimap.create();
    }

    public static class ObservableObserverData {
        private final int networkId;
        private final int dimension;
        private final BlockPos pos;
        private final EnumFacing side;
        private final String name;
        private final long last20TicksDurationNs;

        public PartPos toPartPos() {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (this.getDimension() == world.field_73011_w.getDimension()) {
                return PartPos.of(DimPos.of((World)world, (BlockPos)this.getPos()), this.getSide());
            }
            return null;
        }

        @ConstructorProperties(value={"networkId", "dimension", "pos", "side", "name", "last20TicksDurationNs"})
        public ObservableObserverData(int networkId, int dimension, BlockPos pos, EnumFacing side, String name, long last20TicksDurationNs) {
            this.networkId = networkId;
            this.dimension = dimension;
            this.pos = pos;
            this.side = side;
            this.name = name;
            this.last20TicksDurationNs = last20TicksDurationNs;
        }

        public int getNetworkId() {
            return this.networkId;
        }

        public int getDimension() {
            return this.dimension;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public String getName() {
            return this.name;
        }

        public long getLast20TicksDurationNs() {
            return this.last20TicksDurationNs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObservableObserverData)) {
                return false;
            }
            ObservableObserverData other = (ObservableObserverData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNetworkId() != other.getNetworkId()) {
                return false;
            }
            if (this.getDimension() != other.getDimension()) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            EnumFacing this$side = this.getSide();
            EnumFacing other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLast20TicksDurationNs() == other.getLast20TicksDurationNs();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObservableObserverData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNetworkId();
            result = result * 59 + this.getDimension();
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            EnumFacing $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $last20TicksDurationNs = this.getLast20TicksDurationNs();
            result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
            return result;
        }

        public String toString() {
            return "GuiNetworkDiagnostics.ObservableObserverData(networkId=" + this.getNetworkId() + ", dimension=" + this.getDimension() + ", pos=" + this.getPos() + ", side=" + this.getSide() + ", name=" + this.getName() + ", last20TicksDurationNs=" + this.getLast20TicksDurationNs() + ")";
        }
    }

    public static class ObservablePartData {
        private final int networkId;
        private final int networkCables;
        private final int dimension;
        private final BlockPos pos;
        private final EnumFacing side;
        private final String name;
        private final long last20TicksDurationNs;

        public PartPos toPartPos() {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (this.getDimension() == world.field_73011_w.getDimension()) {
                return PartPos.of(DimPos.of((World)world, (BlockPos)this.getPos()), this.getSide());
            }
            return null;
        }

        @ConstructorProperties(value={"networkId", "networkCables", "dimension", "pos", "side", "name", "last20TicksDurationNs"})
        public ObservablePartData(int networkId, int networkCables, int dimension, BlockPos pos, EnumFacing side, String name, long last20TicksDurationNs) {
            this.networkId = networkId;
            this.networkCables = networkCables;
            this.dimension = dimension;
            this.pos = pos;
            this.side = side;
            this.name = name;
            this.last20TicksDurationNs = last20TicksDurationNs;
        }

        public int getNetworkId() {
            return this.networkId;
        }

        public int getNetworkCables() {
            return this.networkCables;
        }

        public int getDimension() {
            return this.dimension;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public String getName() {
            return this.name;
        }

        public long getLast20TicksDurationNs() {
            return this.last20TicksDurationNs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObservablePartData)) {
                return false;
            }
            ObservablePartData other = (ObservablePartData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNetworkId() != other.getNetworkId()) {
                return false;
            }
            if (this.getNetworkCables() != other.getNetworkCables()) {
                return false;
            }
            if (this.getDimension() != other.getDimension()) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            EnumFacing this$side = this.getSide();
            EnumFacing other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLast20TicksDurationNs() == other.getLast20TicksDurationNs();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObservablePartData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNetworkId();
            result = result * 59 + this.getNetworkCables();
            result = result * 59 + this.getDimension();
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            EnumFacing $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $last20TicksDurationNs = this.getLast20TicksDurationNs();
            result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
            return result;
        }

        public String toString() {
            return "GuiNetworkDiagnostics.ObservablePartData(networkId=" + this.getNetworkId() + ", networkCables=" + this.getNetworkCables() + ", dimension=" + this.getDimension() + ", pos=" + this.getPos() + ", side=" + this.getSide() + ", name=" + this.getName() + ", last20TicksDurationNs=" + this.getLast20TicksDurationNs() + ")";
        }
    }
}

